//************************************************************************//
//                --------  kepler.java  ------------                     //
//                                                                        //
//  Java applet kepler.java to animate elliptical orbits using Kepler's   //  
//  Laws.  Compilation (javac kepler.java) produces two class files:      //
//  java.class and kbarSlider.class.  The program may then be implemented  //
//  from an HTML file containing                                          // 
//                                                                        //
//          <applet code="kepler.class" width=460 height=350>             //
//          Your browser doesn't support JAVA---sorry!                    //
//          </applet>                                                     //
//                                                                        //
//  assuming the two  class files are in the same directory as the        //
//  HTML file (otherwise a complete path to the class files must be       //
//  specified with a codebase=path specification in the applet tag---see  //
//  http://csep10.phys.utk.edu/guidry/java/codebase_spec.html for more    //
//  detail on the use of the codebase specification).                     //
//                                                                        //
//                                Mike Guidry, Jan. 12, 1998              //
//                                guidry@utk.edu                          //
//                                                                        //
//************************************************************************//


import java.applet.*;
import java.awt.*;
import java.net.*;
import java.lang.*;

public class kepler6 extends Applet implements Runnable {
    kbarSlider slide1;
    vbarSlider slide2;
    Button lineOn;
    Button orbitOn;
    Button infoOn;
    static final int nsteps = 300;              // Time steps per revolution
    static final int pixelWidth = 260;          // Width of ellipse in pixels
    static final int xoff = 55;                 // x offset for plot
    static final int yoff = 5;                  // y offset for plot
    int delay = 5;                              // speed control

    //  Conversion factors from Kepler natural units to CGS 
    //  and some basic constants

    static final double secyear=3.155815e+7;
    static final double AUcm = 1.496e+13;
    static final double Msolar = 1.989e+33;
    static final double G = 6.67259e-8;

    //  Input data & associated stuff

    double a = 1.0;                                  // semimajor in AU
    double acm = AUcm * a;                           // semimajor in cm
    double pixelScale = (double)pixelWidth/a/2.0;    // Scale AU --> pixels
    int apixel = (int)(pixelScale*a);                // semimajor in pixels
    double e = 0.65;                                 // eccentricity
    double b = Math.sqrt(a*a*(1.0-e*e));             // semiminor in AU
    int bpixel = (int)(pixelScale*b);                // semiminor in pixels
    double M = 1.0;                                  // total mass (solar)
    double Mgrams = M * Msolar;                      // total mass (grams)
    double P;                                        // period in years
    double Psec;                                     // period in sec
    double r = a*(1.0 - e);                          // r from focus in AU
    double rcm = acm*(1.0 - e);                      // r from focus in cm
    double theta = 0.0;                              // angle from focus
    double dtheta;                                   // angle increment
    double t = 0.0;                                  // time
    double dt;                                       // time increment
    double elast = e;                                // preceding value of e
    double alast = a;                                // preceding value of a
    double Mlast = M;                                // preceding value of M
    int xshift;                                      // java coordinate shift 
    int yshift;                                      // java coordinate shift
    int tcounter=0;                                  // time print interval 
    double timeprint=0.0;                            // printed time
    double r1print=0.0;                              // printed r1  (r1+r2=2a) 
    double r2print=0.0;                              // printed r2  (r1+r2=2a)

    Image sun;
    Image planet;
    int sizeSun;
    int sizePlanet;
    int x = 0; 
    int y = 0;
    Color c1 = new Color(0x000000);
    Color c2 = new Color(0xffffff);
    Font font = new Font("Helvetica", Font.BOLD, 10);
    FontMetrics fontFontMetrics = getFontMetrics(font);
    Font bigfont = new Font("Helvetica", Font.BOLD, 12);
    Image offscreen;
    int imagewidth, imageheight;
    Thread animator = null;
    boolean please_stop = false;
    boolean show_orbit = true;
    boolean psunLine = false;
    boolean showInfo = false;

    public void init() {
        URL codeBase = getCodeBase();
        sun = getImage(codeBase,"siriusA.jpg");
        planet = getImage(codeBase,"siriusB.jpg");


        // Measure size of images being animated.  We need this
        // information later if we do clipping, and for positioning.
        //
        // -----------------------------------------------------------------
        //  Following two methods seem to work with appletviewer, but 
        //  not with browsers (?).  When run under browsers they tend to 
        //  return -1 for the size.  
        //
        //      sizeSun = sun.getWidth(this);
        //      sizePlanet = planet.getWidth(this);
        //
        //  Replaced with the hard-wired sizes below.
        // ------------------------------------------------------------------

        sizeSun = 28;                     // hardwired image size
        sizePlanet = 15;                  // hardwired image size

        //  Calculate period in years from Kepler's 3rd Law and 
        //  convert to CGS units (seconds).  Then calculate the length of
        //  a timestep in seconds.

        P = Math.sqrt(a*a*a/M);
        Psec = secyear * P;
        dt =  Psec/((double) nsteps);   // set negative for counterclockwise

        // Lay out the GUI Display and implement the corresponding
        // event handlers.  First define some colors and fonts and
        // Lay out a set of panels.  Will use BorderLayout to lay out
        // north, south, east, and west panels framing the plot region.
        // Only north and south panels will get widgets.  The event
        // handlers for the widgets are contained in the method 
        // action (Event event, Object arg) defined below, except for
        // the slidebar, which has its own class kbarSlider with its own
        // event handler. 

        Color  panelbg=Color.cyan.darker();
        Color  panelfg=Color.white;
        Color  buttonfg=Color.black;
        Font buttonFont = new Font ("Helvetica",Font.BOLD, 11);

        setLayout(new BorderLayout());
        Panel pt = new Panel();
        add("North",pt);
        pt.setBackground(panelbg);
        Panel pb = new Panel();
        add("South",pb);
        pb.setBackground(panelbg);
        Panel pl = new widePanel();
        add("West",pl);
        pl.setBackground(panelbg);
        Panel pr = new Panel();
        add("East",pr);
        pr.setBackground(panelbg);

        //  Now construct GUI components for the top and bottom panels

        //  Define a toggle switch to turn planet-sun line on or off
        lineOn = new Button (" Show Lines ");
        lineOn.setBackground(Color.pink);
        lineOn.setForeground(Color.black);

        //  Define a toggle switch to turn orbit path on or off
        orbitOn = new Button (" Hide Orbit ");
        orbitOn.setBackground(Color.pink);
        orbitOn.setForeground(Color.black);

        //  Define a toggle switch to turn info labels on or off
        infoOn = new Button (" Show Info ");
        infoOn.setBackground(Color.pink);
        infoOn.setForeground(Color.black);

        //  Choice button to set speed of orbital motion
        Choice setSpeed = new Choice();
        setSpeed.addItem("Fast");
        setSpeed.addItem("Med");
        setSpeed.addItem("Slow");
        setSpeed.setBackground(Color.pink); 
        setSpeed.setForeground(Color.black);

        //  Set a FlowLayout for the top panel, set some colors, 
        //  and then add the components for the top panel

        pt.setLayout(new FlowLayout(FlowLayout.CENTER,10,8));
        pt.setForeground(panelfg);
        pt.setBackground(panelbg);
        pt.setFont(buttonFont);
        pt.add(lineOn);
        pt.add(orbitOn);
        pt.add(infoOn);
        pt.add(setSpeed);


        //  Add the slidebar and its labels to the bottom panel.  
        //  The class kbarSlider has its own GridLayout manager 

        pb.add(slide1=new kbarSlider((int)(e*100.),0,90));
        pl.add(slide2=new vbarSlider(491,491,1,500));
    }



// ---------------------------------------------------------------------
//  Add a method to deal with processing GUI events
//  (buttons, textareas, checkboxes, ... Slidebar events are handled in 
//  a separate class with its own event handler---see class kbarSlider).
//  General mousedown event to toggle animation on an off is handled in
//  the separate method mouseDown defined below.  
// ---------------------------------------------------------------------

    public boolean action(Event event, Object arg) {
       Label flag;
       String s;

/* --- Comment TextField Actions out for now since we don't have any

       //  Process TextField Actions

       if(event.target instanceof TextField) {
           s=textfield1.getText();
           showStatus("TextField Action: "+s +" was the value");

           // TextField processing actions go here //

           //start();
       }

*/       // --- End of commented out section --- //


       //  Process Button Actions.  The button pushed is identified by
       //  its label (the text on its face).  The showStatus command
       //  just displays a message in the status line that button was pushed.
       //  These buttons are set up as 2-state (toggles).  Thus, pushing one
       //  toggles a boolean variable and also toggles the text on the
       //  button face.

       if(event.target instanceof Button) {
           if(arg == " Show Lines ") {
               showStatus("Button Action: "+arg+" pushed");
               psunLine = true;                             // toggle Boolean
               lineOn.setLabel(" Hide Lines ");               // toggle label
           }
           if(arg == " Hide Lines ") {
               showStatus("Button Action: "+arg+" pushed");
               psunLine = false;                            // toggle Boolean
               lineOn.setLabel(" Show Lines ");                  // toggle label
           }
           if(arg == " Show Orbit ") {
               showStatus("Button Action: "+arg+" pushed");
               show_orbit = true;                           // toggle Boolean
               orbitOn.setLabel(" Hide Orbit ");            // toggle label
           }

           if(arg == " Hide Orbit ") {
               showStatus("Button Action: "+arg+" pushed");
               show_orbit = false;                          // toggle Boolean
               orbitOn.setLabel(" Show Orbit ");            // toggle label
           }
           if(arg == " Show Info ") {
               showStatus("Button Action: "+arg+" pushed");
               showInfo = true;                             // toggle Boolean
               infoOn.setLabel(" Hide Info ");              // toggle label
           }

           if(arg == " Hide Info ") {
               showStatus("Button Action: "+arg+" pushed");
               showInfo = false;                            // toggle Boolean
               infoOn.setLabel(" Show Info ");              // toggle label
           }
       }         


/* --- Comment Checkbox template out for now since we don't have any

       //  Process Checkbox actions

       if(event.target instanceof Checkbox) {
           Checkbox checkbox=(Checkbox)event.target;  
           String label=checkbox.getLabel();
           if(label == "Yes") {
                 showStatus("Checkbox Action:  Checkbox=Yes");
                 psunLine=true;
           }
           if(label == "No") {
                 showStatus("Checkbox Action:  Checkbox=No");
                 psunLine=false;
           }
           // stop();
           // start(); 
        }

*/   // --- End of commented out section --- //


       //  Process Choice Menu actions
         
       if(event.target instanceof Choice) {
           if(arg == "Slow") {
               showStatus("Choice Action:  Choice=Slow");
               delay = 100;
           }
           if(arg == "Medium") {
               showStatus("Choice Action:  Choice=Medium");
               delay = 30;
           }
           if(arg == "Fast") {
               showStatus("Choice Action:  Choice=Fast");
               delay = 5;
           }
           // stop();
           // start();
       }

       return true;

    }              //----  End action method ----//



    // Method to toggle stop and start of animation on mouse clicks.
    // Display prompts and mousedown coordinates in status bar

    public boolean mouseDown(Event e, int x, int y) {
        // if running, stop it.  Otherwise, start it.
        // Only accept clicks within rectangle defined by
        // outer if statement.  
        if(x > 18 && x<440 && y>47 && y<312) {   // rectangle for mousedown
            if (animator != null) {
                please_stop = true;
                showStatus("mousedown: x="+x+"  y="+y+"   Click to Restart");
            }    
            else { 
                showStatus("mousedown: x="+x+"  y="+y+"   Click to Stop");
                please_stop = false; 
                start(); 
            }
        } 
        return false;
    }


    // Method to start the animation

    public void start() {
        e = kbarSlider.slideval; 
        animator = new Thread(this);
        animator.start();
    }


    // Method to stop the animation 

    public void stop() { 
        if (animator != null) animator.stop();
        animator = null;
    }




    // Method to draw the applet plot background and to update
    // quantities calculated using e, M, or a if these quantities
    // change because of input from the GUI widgets
 
    void drawBackground(Graphics gr, Color c1) {
        e = kbarSlider.slideval;
        M = vbarSlider.slideval;
        a = vbarSlider.slideval2;
        if(e != elast || a != alast || M != Mlast) {  // An input has changed
            acm = AUcm * a;
            pixelScale = (double)pixelWidth/a/2.0;
            apixel = (int)(pixelScale*a);
            b = Math.sqrt(a*a*(1.0-e*e));
            bpixel = (int)(b*pixelScale);
            Mgrams = M * Msolar;
            P = Math.sqrt(a*a*a/M);
            Psec = secyear * P;
            dt = Psec/((double) nsteps); //  Set negative for counterclockwise
            if(e != elast){t=0.0;}       //  Reset time if e has changed
        }
        Dimension size = this.size();
        int w = size.width; 
        int h = size.height;
        gr.setColor(c1);
        gr.fillRect(0, 0, w, h);
        xshift = w/2 + (int)(e*a*pixelScale) + xoff;
        yshift = h/2 +yoff; 
        gr.drawImage(sun, xshift - sizeSun/2, yshift - sizeSun/2, this);
        if (show_orbit == true){
            gr.setColor(Color.gray); 
            gr.drawOval(w/2-apixel+xoff, yshift-bpixel, 2*apixel, 2*bpixel); 
        }

        int xlc = 45;        // offset of printed quantities from left axis
        gr.setFont(font);
        gr.setColor(Color.cyan);
        gr.drawString("e = "+decimalPlace(2,e),xlc,60);
        gr.drawString("a = "+decimalPlace(2,a)+" AU",xlc,74);
        gr.drawString("M = "+decimalPlace(2,M)+" solar",xlc,88);
        gr.drawString("Period = "+decimalPlace(2,P)+" yr",xlc,102);

        // Print a scale legend
        int scalex = 385;
        int scaley = 315;
        int scalepix = pixelWidth/4;
        gr.setFont(font);
        double scalewid = ( (double)scalepix/pixelScale );
        String scalewidS = decimalPlace(1,scalewid)+" AU";
        int scaleoff = fontFontMetrics.stringWidth(scalewidS);
        gr.drawString(scalewidS, scalex+scalepix/2-scaleoff/2, scaley-10);
        gr.drawLine(scalex, scaley, scalex+scalepix, scaley);
        gr.drawLine(scalex, scaley+5, scalex, scaley-5);
        gr.drawLine(scalex+scalepix, scaley+5, 
                          scalex+scalepix, scaley-5);

        //  Print elapsed time, r1, and r2 every 20 time steps
        //  (where r1+r2=2a for the ellipse)

        tcounter = (tcounter+1)%21;
        if (tcounter == 1){
            timeprint=t;
            r1print = r;
            r2print = 2.*a -r;
        }

        //  Draw planet-sun  and planet-other focus line
        if (psunLine == true){
            gr.setColor(Color.cyan);
            gr.drawLine(x,y,xshift,yshift);
            gr.drawLine(x,y,xshift-2*(int)(e*(double)apixel), yshift);
            gr.fillOval(xshift-2*(int)(e*(double)apixel)-2, yshift-2, 4, 4);
            gr.fillOval(xshift-2, yshift-2, 4, 4);
            gr.setFont(font);
            String str1 = "Distance r(1) = ";
            String str2 = "Distance r(2) = ";
            String str3 = "r(1) + r(2) = ";
            String str4 = "Distance r(1) = "+decimalPlace(2,r1print);
            int widstr1 = fontFontMetrics.stringWidth(str1);
            int widstr2 = fontFontMetrics.stringWidth(str2);
            int widstr3 = fontFontMetrics.stringWidth(str3);
            int widstr4 = fontFontMetrics.stringWidth(str4);
            int ypos1 = 280;
            gr.setFont(bigfont);
            gr.drawString("r(1) + r(2) = 2a:", xlc, ypos1-20);
            gr.setColor(Color.green);
            gr.setFont(font);
            gr.drawString("Distance r(1) = "+decimalPlace(2,r), xlc, 
                             ypos1);
            gr.drawString("Distance r(2) = "+decimalPlace(2,2.*a-r), 
                             xlc+(widstr1-widstr2), ypos1+14);
            gr.drawLine(xlc, ypos1+18, xlc+widstr4, ypos1+18);
            gr.drawString("r(1) + r(2) = "+decimalPlace(2,
                             r+(2.*a-r)+.0001*r), 
                             xlc+(widstr1-widstr3), ypos1+32);
        }
        gr.setColor(Color.cyan);
        String timestring=decimalPlace(2,timeprint/secyear);
        gr.drawString("Time = "+timestring+" yr",xlc,116);
        gr.drawString("R = "+decimalPlace(2,r)+" AU",xlc,130);

        //  Display info if the switch is toggled to true

        if(showInfo == true) {
            gr.setColor(Color.pink);

            // label for semimajor axis
            gr.drawLine(w/2+xoff-apixel, yshift, w/2+xoff, yshift);
            gr.setFont(font);
            int xwida = fontFontMetrics.stringWidth("a = x.x AU");
            gr.setColor(Color.cyan);
            gr.drawString("a = "+decimalPlace(2,a)+" AU", 
                         (w/2+xoff-apixel/2)-xwida/2, yshift-15);
            
            // label for semiminor axis
            int ywidb = fontFontMetrics.getAscent()/2;
            gr.drawString("b = "+decimalPlace(2,b)+" AU", 
                          w/2+xoff+10, yshift-bpixel/2+ywidb); 
            gr.setColor(Color.pink);
            gr.drawLine(w/2+xoff, yshift, w/2+xoff, yshift-bpixel);

            // label for foci
            gr.setColor(Color.cyan);
            gr.fillOval(xshift-2*(int)(e*(double)apixel)-2, yshift-2, 4, 4);
            gr.fillOval(xshift-2, yshift-2, 4, 4);
            gr.setColor(Color.white);
     //       gr.drawLine(xshift, yshift, 190, 270);
       //     gr.drawLine(xshift-2*(int)(e*(double)apixel), yshift, 
         //                 190, 270);
            gr.drawLine(xshift, yshift, w/2+xoff, yshift+bpixel/2);
            gr.drawLine(xshift-2*(int)(e*(double)apixel), yshift, 
                          w/2+xoff, yshift+bpixel/2);
            gr.setColor(Color.cyan);
            int focwid = fontFontMetrics.stringWidth("Foci");
            gr.drawString("Foci", w/2+xoff-focwid/2, yshift+bpixel/2+15);
           // gr.drawString("Foci", 175, 285);
        }
        elast = e;         // Old values of e, a, M to test whether 
        alast = a;         // widgets have been moved
        Mlast = M;         // Tested at top of this method
    }



//  Method decimalPlace returns string that is string representation of double
//  with a fixed number of places after the decimal.  The number of places
//  after the decimal is given by the integer "nright" and the double is 
//  passed as the variable "number".  Routine assumes number is not in
//  scientific (e) notation.  Presently no check is made to ensure that
//  this is true. Should be easy to fix that.  Also, the string returned is
//  rounded down to the next digit in the last place.  e.g., 
//  decimalPlace(2, 3.678) returns the string "3.67".
//  Finally present version does no padding to fill out right 
//  zeroes, so for example if you ask for 2 decimal places, 0. will be returned
//  as 0., not 0.00.
// 
//  EXAMPLE USE:  String nstring = decimalPlace(nright,number)
//  EXAMPLE USE:  g.drawString("Variable=" + decimalPlace(3,variable),100,200)
 

    public String decimalPlace(int nright, double number) {
        double n=number;
        String tright2="";
        String total=String.valueOf(n);
        int nperiod=total.indexOf(".");
        if(nperiod == 0 || nperiod == -1){return total;}
        String tleft=total.substring(0,nperiod);
        String tright=total.substring(nperiod);
        int temp1=0, temp2=nright+1;
        if(tright.length() > nright) {
            try{tright2=tright.substring(temp1,temp2);}
                catch (StringIndexOutOfBoundsException e) 
            { ; }
        }
        else {
            tright2=tright;
        }
        return tleft+tright2;
    } 


// Draw background and images at their current positions

    public void paint(Graphics g) {
        drawBackground(g, c1);
        g.drawImage(planet, x-sizePlanet/2, y-sizePlanet/2, this);  
    }


//  Main animator thread.  The animation thread is based  on
//  an example from the book _Java in a Nutshell_ by David Flanagan,
//  and implements both double buffering and clipping techniques to
//  prevent flickering.  However, clipping is presently commented
//  out.

    public void run() {
        while(!please_stop) {
            Dimension d = this.size();
            
            // Create offscreen image at the right size.
            if ((offscreen == null) ||
                ((imagewidth != d.width) || (imageheight != d.height))) {
                // if (offscreen != null) offscreen.flush();
                offscreen = this.createImage(d.width, d.height);
                imagewidth = d.width;
                imageheight = d.height;
            }
            
            // Set up clipping.  We only need to draw within the
            // old rectangle that needs to be cleared and the new
            // one that is being drawn.

            // the old rectangle
            Rectangle oldrect = new Rectangle(x-sizePlanet/2, y-sizePlanet/2, 
                                sizePlanet, sizePlanet);
            // Update the coordinates for animation.
            //  Update time and theta

            t = t + dt;            // Subtract dt for counterclockwise

            dtheta = Math.sqrt(G*Mgrams*acm*(1.0 - e*e))*dt/rcm/rcm;
            theta = theta + dtheta; 

            //  Calculate new r relative to focus of ellipse
            r = a*(1.0 - e*e)/(1.0 + e*Math.cos(theta));
            rcm = AUcm * r;

            //  Calculate relative x and y in pixels
            int xrel = (int)(r * Math.cos(theta) * pixelScale);
            int yrel = (int)(r * Math.sin(theta) * pixelScale);

            //  Calculate new x and y relative to focus
            x = xrel + xshift;
            y = yrel + yshift;

            // the new rectangle
            Rectangle newrect = new Rectangle(x-sizePlanet/2, y-sizePlanet/2, 
                                sizePlanet, sizePlanet);
            // Compute the union of the rectangles
            Rectangle r = newrect.union(oldrect);
                
            // Use this rectangle as the clipping region when
            // drawing to the offscreen image, and when copying
            // from the offscreen image to the screen.
            // Clipping is disabled if the two g.clipRect() statements
            // below are commented out.  Clipping allows only the
            // planet to be redrawn, so if enabled the applet will not
            // redraw orbits and Sun position and labels when e slider 
            // is changed.
 
            Graphics g = offscreen.getGraphics();
            //   g.clipRect(r.x, r.y, r.width, r.height);
            // Draw into the off-screen image.
            paint(g);
            // Copy it all at once to the screen, using clipping.
            g = this.getGraphics();
            //   g.clipRect(r.x, r.y, r.width, r.height);
            g.drawImage(offscreen, 0, 0, this);
            
            // wait then draw it again
            try { Thread.sleep(delay); } catch (InterruptedException e) { ; }
        }
        animator = null;
    }
}       

            // ----------- End class kepler ----------------- //



/******************************************************************  //
//                                                                   //
//  Class kbarSlider implements a horizontal slidebar for input of    //
//  eccentricity.  Class has its own event processor that sets the   //
//  class double variable "slideval" equal to the value of the       //
//  slidebar when it is moved. This variable may then be accessed    //
//  from another class by creating a kbarSlider object and then       //
//  accessing its slideval field.  EXAMPLE:                          //
//                                                                   //
//       kbarSlider bslide = new kbarSlider(int i, int min, int max);  //
//       double number = bslide.slideval;                            //
//                                                                   //
//  The class has its own GridLayout manager implemented so a        //
//  typical GUI would add  an instance of the class as a             //
//  component to a panel.  EXAMPLE:                                  //
//                                                                   //
//       kbarSlider bslide = new kbarSlider(int i, int min, int max);  //
//       Panel newpanel = new Panel();                               //
//       newpanel.add(bslide);                                       //
//                                                                   //
//  Variables:                                                       //
//  int i = initial value of slider 1                                //
//  int min = minimum value for slider                               //
//  int max = maximum value for sliders                              //
//                                                                   //
//                                    Mike Guidry Feb. 20, 1997      //
//                                                                   //
// *******************************************************************/



class kbarSlider extends Panel {
    Scrollbar slider;
    Label value, elabel;
    static double slideval;
    Font font = new Font("Helvetica", Font.BOLD, 10);
    kepler kp = new kepler();   // To be able to access decimalPlace method
                                // of the class kepler through kp.decimalPlace 

    public kbarSlider(int i, int min, int max) {
         setFont(font);
         setLayout(new GridLayout(1,3,15,15));
         add(elabel = new Label("e: ",Label.RIGHT));
         elabel.setForeground(Color.black);
         add(slider = new Scrollbar(Scrollbar.HORIZONTAL,
                          i, 1, min, max));
         slider.setBackground(Color.lightGray);
      add(value = new Label(kp.decimalPlace(1,(double)i/100.),Label.LEFT));
//         add(value = new Label(String.valueOf((float)i/100.),Label.LEFT));
         value.setForeground(Color.black);
         slideval=(double)i/100.; 
    }

    public boolean handleEvent(Event evt) {
       if (evt.target.equals(slider)) {
           int i = slider.getValue();
           value.setText(kp.decimalPlace(2, (double)i/100.));   
//           value.setText(String.valueOf((float)i/100.));   
           slideval=(double)i/100.;
       }
        return true;
    }

//  Rescale the preferred size of slider in the layout
//  If this rescale is removed the slider typically collapses 
//  down to minimal width with no slide bar showing (i.e., it
//  becomes a left-right arrow control).

    public Dimension preferredSize() {
        return new Dimension(800, 15);
    }
}       

//      ----- End class kbarSlider -----



/******************************************************************  //
//                                                                   //
//  Class vbarSlider implements 2 vertical slidebars for input of   //
//  mass.  Class has its own event processor that sets the           //
//  class double variable slideval equal to the value of the         //
//  first slidebar when it is moved and slideval2 equal to the value //
//  of the second slidebar when it is moved.  These variables may    //
//  then be accessed from another class by creating a vbarSlider    //
//  object and then  accessing its slideval and slideval2 fields.    //
//  EXAMPLE:                                                         //
//                                                                   //
//       int i,j,min,max                                             //
//       vbarSlider bslide = new vbarSlider(i, j, min, max);       //
//       double number = bslide.slideval;                            //
//       double number2 = bslide.slideval2;                          //
//                                                                   //
//  The class has its own GridLayout manager implemented so a        //
//  typical GUI would add  an instance of the class as a             //
//  component to a panel.  EXAMPLE:                                  //
//                                                                   //
//       vbarSlider bslide = new vbarSlider(i, j, min, max);       //
//       Panel newpanel = new Panel();                               //
//       newpanel.add(bslide);                                       //
//                                                                   //
//  Variables:                                                       //
//  int i = initial value of slider 1                                //
//  int j = initial value of slider 2                                //
//  int min = minimum value for sliders (presently same for both)    //
//  int max = maximum value for sliders (   "       "    "   "  )    //
//                                                                   //
//  (See class barSliderV2R for example with two sliders having      //
//  different limits)                                                //
//                                                                   //
//                                                                   //
//                                    Mike Guidry Feb. 20, 1997      //
//                                                                   //
// *******************************************************************/



class vbarSlider extends Panel {
    Scrollbar slider, slider2;
    Label value1,value2,value3,value4;
    static double slideval,slideval2;
    Font font = new Font("Helvetica", Font.PLAIN, 10);
    kepler kp = new kepler();   // To be able to access decimalPlace method
                                // of the class kepler through kp.decimalPlace

    public vbarSlider(int i, int j, int min, int max) {
         setFont(font);
         setLayout(new GridLayout(6,1,0,0));
         add(value2 = new Label(kp.decimalPlace(1,(double)(501-i)/10.),
                     Label.CENTER));
         value2.setForeground(Color.black);
         add(slider = new Scrollbar(Scrollbar.VERTICAL,
                          i, 1, min, max));
         slider.setBackground(Color.lightGray);
         add(value1 = new Label("M",Label.CENTER));
         value1.setForeground(Color.black);
         add(value4 = new Label(kp.decimalPlace(1,(double)(501-j)/10.),
                     Label.CENTER));
         value4.setForeground(Color.black);
         add(slider2 = new Scrollbar(Scrollbar.VERTICAL,
                          j, 1, min, max));
         slider2.setBackground(Color.lightGray);
         add(value3 = new Label("a",Label.CENTER));
         value3.setForeground(Color.black);
         slideval=(double)(501-i)/10.;
         slideval2=(double)(501-j)/10.;
    }

    public boolean handleEvent(Event evt) {
       if (evt.target.equals(slider)) {
           int i = slider.getValue();
           value2.setText(kp.decimalPlace(1,(double)(501-i)/10.));
           slideval=(double)(501-i)/10.;
       }
       if (evt.target.equals(slider2)) {
           int i = slider2.getValue();
           value4.setText(kp.decimalPlace(1,(double)(501-i)/10.));
           slideval2=(double)(501-i)/10.;
       }
        return true;
    }

//  Rescale the preferred size of buttons in the layouts

    public Dimension preferredSize() {
        return new Dimension(20,310);
    }
}

//      ----- End class vbarSlider -----



class widePanel extends Panel {

//  Over-rides the perferredSize() & minimumSize() methods of the Panel class
//  to allow control of a panel size.  Example usage:  create an object of
//  the widePanel class:  widePanel npanel = new widePanel();
//  Then the dimensions of npanel can be controlled by changing the
//  parameters in the dimension statements below.  Otherwise, it has
//  all the properties of a normal Panel class object.

    public Dimension preferredSize() {      // over-ride preferred size
        return new Dimension(30, 300);
    }
    public Dimension minimumSize() {        // over-ride mimunum size
        return new Dimension(30, 300);
    }
}
