// Planet.java 
 
// a generic planet and star 
// planet mass  not neglected
 
// 
//  class  method       qualifiers 
// 
//  Planet              A R 
//         init         p v 
//         paint        p v 
//         start        p v 
//         stop         p v 
//         run          p v 
//         update       p v     may be commented out 
//         main         p s v   not used as applet 
 
 
import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.util.Date;
import java.io.*; 
 
public class Planet extends Applet implements Runnable { 


Panel panelT = new Panel(); 
//Panel panelH = new Panel(); 
Panel panelV = new Panel(); 
// new nested scrollbar panels
Panel panelv1 = new Panel();
Panel panelv2 = new Panel();
Panel panelv3 = new Panel();
Panel panelv4 = new Panel();
Panel panelv4b= new Panel();
Button button0v,button1v,button2v,button3v,button4v,button6v,button7v,
button7av,button7bv,button8v,button9v,button10v,button11v;
Scrollbar sm1,sm2,sa,seps; 
Choice doublechoice = new Choice(); 
HelpFrameP helpframe; 
// the instance of Thread for checking the time periodically 
Thread thread = null; 
 
// planet and star setup data 
// funny numbers are because it uses first index = 0 
// but i use 1,2,...,n_objects 
// number of systems stored 
public int ndoubles=11; 
public double adata[]   = new double[21]; 
public double mplanetjups[]  = new double[21]; 
public double m12ratiodata[]  = new double[21]; 
public double masspdata[]  = new double[21]; 
public double masssdata[]  = new double[21]; 
public double msum[]  = new double[21]; 
public double epsdata[] = new double[21]; 
public double pyrs;
public String doublenamedata[] = new String[21];
public String aftertext[] = new String[21]; 
public String doublename; 
//public String splanet;
private Image offScreenImage;
public Image img1data[] = new Image[21];
public Image img2data[] = new Image[21]; 
public Color ai_textcolor = new Color(144,196,196);
public Color label1color[] = new Color[21]; 
public Color label2color[] = new Color[21]; 
public Color labelcolor[] = new Color[8]; 
public Image imglibdata[] = new Image[8]; 
public int ipalette=1;
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
public Color std_black = new Color(  0,  0,  0);
public int doublenumber=0; 
public double mass1; 
public double mass2; 
public double ratiojsun = 317.89/332960.;
public double ratio_aupy_mps = 1000. * 14.9599/3.155815;
public double astars; 
public double epsilon; 
public int nstars  =3; 
public int ncoords =4; 
public double xstarprev,ystarprev;
public double dxstar,dystar;
public double vxstar,vystar;
public double vxstarmps,vystarmps;
public double xstar[][] = new double[nstars][ncoords]; 
//public double vstar[][] = new double[nstars][ncoords]; 
 
// screen setup 
Image imgstar[] = new Image[nstars]; 
public double screenscale; 
public double radscrn; 
public double rdisplaymax=1.01; 
public double rdisplaymin=0.49; 
public static double pi=3.14159265358979323; 
 
// array declarations that actually work: 
//int numvals=30; 
//double numbers[][] = new double[numvals][numvals]; 
//float numbers[] = new float[30]; 
 
public double dtime; 
public double time = 0.0; 
public double theta=0.0; 
 
// for axis and data drawing 
// istep=false allows screen clear or adjust w/o stepping time 
public boolean isim    = true;
public boolean istep   = false; 
public boolean igrid   = false; 
public boolean ilabels = true; 
public boolean iorbit = false; 
public boolean ifaster=false;
public boolean islower=false;
public int ix1,ix2,ix3,ix4,ix5,iy1,iy2,iy3,iy4,iy5;
public int ticx1,ticx2,ticy1,ticy2,mrone,mrhalf,mrquart; 
public int ixreps1,iyreps1,ixreps2,iyreps2; 
//// sounds 
//AudioClip beep[] = new AudioClip[10]; 
 
public void init(){ 

//// a not yet successful attempt to read a mixed text and data file
//
//try
//  {
//RandomAccessFile file = new RandomAccessFile("Planet.dat", "r");
//long filePointer=0;
//int index=0;
//String stest;
//int itest;
//int itest2=200;
//long length = file.length();
//while(filePointer < length)
//      {
//       doublenamedata[index] = file.readLine();
//       aftertext     [index] = file.readLine();     
//       itest = file.readInt();
////       file.writeInt(itest2);
//
////       epsdata       [index] = file.readDouble();
////       adata         [index] = file.readDouble();
////       mplanetjups   [index] = file.readDouble();
////       masssdata     [index] = file.readDouble();
//
//       System.out.println(index);
//       System.out.println(doublenamedata[index]);
//       System.out.println(aftertext     [index]);
//       System.out.println(String.valueOf(itest));
//
////       System.out.println(String.valueOf(epsdata[index]));
////       System.out.println(String.valueOf(adata[index]));
////       System.out.println(String.valueOf(mplanetjups[index]));
////       System.out.println(String.valueOf(masssdata[index]));
//       System.out.println("xxx"); 
//       filePointer = file.getFilePointer();
//       index +=1;
//       }
//  }
//catch (Exception e)
//  {
//   String err = e.toString();
//   System.out.println(err);
//  }
//


    offScreenImage = createImage(size().width,size().height);
// load generic star images 
 
    imgstar[1] = getImage(getDocumentBase(),"sun_yellow.jpg"); 
    imgstar[2] = getImage(getDocumentBase(),"sun_blue.jpg"); 
 
    imglibdata[1] = getImage(getDocumentBase(),"star_O.jpg"); 
    imglibdata[2] = getImage(getDocumentBase(),"star_B.jpg"); 
    imglibdata[3] = getImage(getDocumentBase(),"star_A.jpg"); 
    imglibdata[4] = getImage(getDocumentBase(),"star_F.jpg"); 
    imglibdata[5] = getImage(getDocumentBase(),"star_G.jpg"); 
    imglibdata[6] = getImage(getDocumentBase(),"star_K.jpg"); 
    imglibdata[7] = getImage(getDocumentBase(),"star_M.jpg"); 

    labelcolor[1] = new Color(0,255,255);
    labelcolor[2] = new Color(200,255,255);
    labelcolor[3] = new Color(244,244,244);
    labelcolor[4] = new Color(255,255,164);
    labelcolor[5] = new Color(255,255,0);
    labelcolor[6] = new Color(255,148,0);
    labelcolor[7] = new Color(255,0,0);


 
// instances of planets (Javaspeak) 
 
    doublenamedata[0]    = "Earth";
    aftertext     [0]    = "";
//// 1st is planet, 2nd is star 
    epsdata       [0]    = 0.0167;
    adata         [0]    = 1.000;
// planet mass in Jupiters, star mass in Msuns
    mplanetjups   [0]    = 1.0/317.89;
    masssdata     [0]    = 1.0;

    doublenamedata[1]    = "Jupiter"; 
    aftertext     [1]    = "";
    epsdata       [1]    = 0.0485;
    adata         [1]    = 5.203;
    mplanetjups   [1]    = 1.0;
    masssdata     [1]    = 1.0;
 
    doublenamedata[2]    = "47 UMa"; 
    aftertext     [2]    = " and planet";
    epsdata       [2]    = 0.03;
    adata         [2]    = 2.1;
    mplanetjups   [2]    = 2.4;
    masssdata     [2]    = 1.1;
 
 
    doublenamedata[3]    = "16 Cyg B"; 
    aftertext     [3]    = " and planet";
    epsdata       [3]    = 0.57;
    adata         [3]    = 1.7;
    mplanetjups   [3]    = 1.7;
    masssdata     [3]    = 1.0;
 
 
    doublenamedata[4]    = "HD 114762"; 
    aftertext     [4]    = " in Coma Berenice and planet";
    epsdata       [4]    = 0.34;
    adata         [4]    = 0.36;
    mplanetjups   [4]    = 11.6;
    masssdata     [4]    = 1.15;

    doublenamedata[5]    = "70 Vir";
    aftertext     [5]    = " and planet";
    epsdata       [5]    = 0.40;
    adata         [5]    = 0.47;
    mplanetjups   [5]    = 6.8;
    masssdata     [5]    = 0.95;
 
 
    doublenamedata[6]    = "Rho CrB";
    aftertext     [6]    = " and planet";
    epsdata       [6]    = 0.04;
    adata         [6]    = 0.23;
    mplanetjups   [6]    = 1.1;
    masssdata     [6]    = 1.0;
 
    doublenamedata[7]    = "Rho1 Cnc";
    aftertext     [7]    = " and planet";
    epsdata       [7]    = 0.03;
    adata         [7]    = 0.11;
    mplanetjups   [7]    = 0.93;
    masssdata     [7]    = 0.85;
 
    doublenamedata[8]    = "Upsilon And";
    aftertext     [8]    = " and planet";
    epsdata       [8]    = 0.1;
    adata         [8]    = 0.056;
    mplanetjups   [8]    = 0.65;
    masssdata     [8]    = 1.25;
 
    doublenamedata[9]    = "51 Peg";
    aftertext     [9]    = " and planet";
    epsdata       [9]    = 0.01;
    adata         [9]    = 0.051;
    mplanetjups   [9]    = 0.45;
    masssdata     [9]    = 1.0;
 
    doublenamedata[10]    = "Tau Boo";
    aftertext     [10]    = " and planet";
    epsdata       [10]    = 0.006;
    adata         [10]    = 0.045;
    mplanetjups   [10]    = 3.7;
    masssdata     [10]    = 1.25;
 
 
 
    for(int idbl=0; idbl<ndoubles; ++idbl){ 
    img1data      [idbl]    = imglibdata[1]; 
    img2data      [idbl]    = imglibdata[5];
    label1color   [idbl]    = std_gray1;
    label2color   [idbl]    = labelcolor[5];
    masspdata[idbl] = mplanetjups[idbl]*ratiojsun;
    msum[idbl] = masspdata[idbl] + masssdata[idbl];
    } 
 
this.setBackground(Color.black); 
this.setLayout(null); 
panelV.setLayout (null); 
      panelV.setBounds(0,320,520,20);
// defines buttons 
    button0v = new Button("About"); 
    button1v = new Button("Start"); 
    button3v = new Button("Reset"); 
    button4v = new Button("Orbit"); 
    button6v = new Button("Grid"); 
    button7av= new Button("Faster");
    button7bv= new Button("Slower");
    button8v = new Button("Labels");  
// sets button bounds 
    button1v.setBounds ( 25,0,50,20); 
    button3v.setBounds ( 85,0,50,20); 
    button4v.setBounds (145,0,50,20); 
    button6v.setBounds (205,0,50,20); 
    button7av.setBounds(265,0,50,20); 
    button7bv.setBounds(325,0,50,20); 
    button8v.setBounds (385,0,50,20); 
    button0v.setBounds (445,0,50,20); 
// adds buttons 
    panelV.add(button1v); 
    panelV.add(button3v); 
    panelV.add(button4v); 
    panelV.add(button6v); 
    panelV.add(button7av); 
    panelV.add(button7bv); 
    panelV.add(button8v); 
    panelV.add(button0v); 
    add(panelV);
 


panelV.setBackground(Color.black);


 

// color buttons
    if(ipalette==1){
    button0v.setBackground(std_gray2);     
    button1v.setBackground(std_gray2); 
    button3v.setBackground(std_gray2); 
    button4v.setBackground(std_gray2); 
    button6v.setBackground(std_gray2); 
    button7av.setBackground(std_gray2); 
    button7bv.setBackground(std_gray2); 
    button8v.setBackground(std_gray2);  
}
    if(ipalette==3){
    button0v.setBackground(new Color(200,000,200)); 
    button1v.setBackground(new Color(100,200,100)); 
    button3v.setBackground(new Color(200,100,100)); 
    button4v.setBackground(new Color(100,100,255)); 
    button6v.setBackground(new Color(100,100,255)); 
    button7av.setBackground(new Color(100,100,255)); 
    button7bv.setBackground(new Color(100,100,255)); 
    button8v.setBackground(Color.gray); 
}
 


//// adds buttons 
//    panelV.add(button0v);
//    panelV.add(button1v); 
//    panelV.add(button2v); 
//    panelV.add(button3v); 
//    panelV.add(button4v); 
////    panelV.add(button5v); 
//    panelV.add(button6v); 
//    panelV.add(button7v); 
//    panelV.add(button8v); 
//    panelV.add(button9v); 
//    panelV.add(button5v); 
//// color buttons
//    button0v.setBackground(new Color(200,000,200)); 
//    button1v.setBackground(new Color(100,200,100)); 
//    button2v.setBackground(new Color(200,100,100)); 
//    button3v.setBackground(new Color(200,100,100)); 
//    button4v.setBackground(new Color(100,100,255)); 
//    button5v.setBackground(new Color(100,100,255)); 
//    button6v.setBackground(new Color(100,100,255)); 
//    button7v.setBackground(new Color(100,100,255)); 
//    button8v.setBackground(new Color(100,100,255)); 
//    button9v.setBackground(Color.gray); 

// add choicepanel doubles
    for(int idbl=0; idbl<ndoubles; ++idbl){ 
    doublechoice.addItem(doublenamedata[idbl]); 
    } 

// new panel test
      panelv1.setLayout(null);
      panelv1.setBounds(420,40,100,15);
      add(panelv1);
// for future ref. this is how you add a nested button
//      buttontest = new Button();
//      buttontest.setLabel("Test");
//      buttontest.setBounds(10,10,40,20);
//      buttontest.setBackground(new Color(100,100,255));
//      panelv1.add(buttontest);
      sm1 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,101); 
// nest a scrollbar in the panel
      sm1.setBounds(0,0,100,15);
      sm1.setBackground(std_gray2);
      panelv1.add(sm1);

      panelv2.setLayout(null);
      panelv2.setBounds(420,100,100,15);
      add(panelv2);
      sm2 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,101);
      sm2.setBounds(0,0,100,15);
      sm2.setBackground(std_gray2);
      panelv2.add(sm2);

      panelv3.setLayout(null);
      panelv3.setBounds(420,160,100,15);
      add(panelv3);
      sa = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,501);
      sa.setBounds(0,0,100,15);
      sa.setBackground(std_gray2);
      panelv3.add(sa);

      panelv4.setLayout(null);
      panelv4.setBounds(420,220,100,15);
      add(panelv4);
      seps = new Scrollbar (Scrollbar.HORIZONTAL,0,1,0,96);
      seps.setBounds(0,0,100,15);
      seps.setBackground(std_gray2);
      panelv4.add(seps);

      panelv4b.setLayout(null);
      panelv4b.setBounds(420,280,100,20);
      panelv4b.setBackground(Color.black);
      add(panelv4b);
// add choicepanel
      doublechoice = new Choice();
      doublechoice.setBounds(0,0,100,20);
      doublechoice.setBackground(std_white);
      for(int idbl=0; idbl<ndoubles; ++idbl){
      doublechoice.addItem(doublenamedata[idbl]);
      } 
      panelv4b.add(doublechoice);
 
// needed for axis drawing 
    Dimension d = size(); 
    screenscale= 0.8 * (double) d.height; 
    radscrn=screenscale; 
    mrone = (int) screenscale; 
    mrhalf= (int) (0.5*screenscale); 
    mrquart=(int) (0.25*screenscale);  
    ticy1= (int) (0.48*screenscale); 
    ticy2= (int) (0.52*screenscale); 
    ix1=0; 
    ix2= mrquart; 
    ix3= mrhalf; 
    ix4= 3*mrquart; 
    ix5= mrone; 
    ticx1= ticy1; 
    ticx2= ticy2; 
    iy1=0; 
    iy2= mrquart; 
    iy3= mrhalf; 
    iy4= 3*mrquart; 
    iy5= mrone; 
 
// setup start coords and veloc 
    time=0.0; 
    theta=0.0; 
// start with 1st dbl in list 
//   mass1    = msum[0]*m12ratiodata[0]/(1.0+m12ratiodata[0]); 
//   mass2    = msum[0]                /(1.0+m12ratiodata[0]); 
   mass1 = masspdata[0];
   mass2 = masssdata[0];
   astars   = adata[0]; 
   epsilon  = epsdata[0]; 
   doublename = doublenamedata[0]; 
// period of orbit 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    dtime = 0.001*pyrs; 
 
 
////  get sounds 
//    String name1,name2; 
//    name1 = "drip.au"; 
//    showStatus("Getting "+name1); 
//    beep[1] = getAudioClip(getCodeBase(),name1); 
//    beep[1].play(); 
//    name2 = "spacemusic.au"; 
//    showStatus("Getting "+name2); 
//    beep[2] = getAudioClip(getCodeBase(),name2); 
////    beep[2].play(); 
 
} 
 
// scrollbars 
 
public boolean handleEvent(Event evt){ 
   if(evt.target instanceof Scrollbar){
      thread = null; 
      isim=false;
      button1v.setLabel("Start"); 
      doublechoice.setBackground(std_black);
      time=0.0; 
      theta=0.0; 
      mass1 = 0.1*ratiojsun*(double) (sm1.getValue()); 
      mass2 = 0.1*(double) (sm2.getValue()); 
      astars= 0.1*(double) (sa.getValue()); 
      epsilon=0.01*(double) (seps.getValue()); 
// period of orbit 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    dtime = 0.001*pyrs; 
      istep  = false; 
      repaint(); 
      return true; 
   }
   else 
   { 
      boolean result = super.handleEvent(evt); 
      return result; 
   } 
} 
 
 
public boolean action(Event evt, Object arg){ 
 
 if(evt.target.equals (doublechoice)){ 
    thread = null; 
//        button1v.setBackground(new Color(100,200,100)); 
//        button2v.setBackground(new Color(200,100,100)); 
//        button3v.setBackground(new Color(200,100,100)); 
//        button9v.setBackground(Color.gray); 
        button1v.setLabel("Start");
        panelV.add(button1v); 
//        panelV.add(button2v); 
//        panelV.add(button3v); 
        doublechoice.setBackground(Color.white);
        doublechoice.setForeground(Color.black);
    isim=true; 
    time=0.0; 
    theta=0.0; 
    doublenumber = doublechoice.getSelectedIndex(); 
    astars  = adata[doublenumber]; 
    mass1 = masspdata[doublenumber];
    mass2 = masssdata[doublenumber];
    epsilon = epsdata[doublenumber]; 
    doublename = doublenamedata[doublenumber]; 
// period of orbit 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    dtime = 0.001*pyrs; 
    sm1.setValue( (int) (10.0*mass1/ratiojsun) );
    sm2.setValue( (int) (10.0*mass2) );
    sa.setValue(  (int) (10.0*astars));
    seps.setValue((int) (100.0*epsilon));
    istep=false; 
    repaint(); 
    } 
 
 if(evt.target instanceof Button){ 
       if(arg == "Start") {
//         beep[1].play(); 
//         button1v.setBackground(new Color(0,255,0)); 
//         button2v.setBackground(new Color(200,100,100)); 
//         button3v.setBackground(new Color(200,100,100)); 
         button1v.setLabel("Stop");
         panelV.add(button1v); 
         if(isim == false){
         doublechoice.setBackground(Color.black);
//         doublechoice.setForeground(Color.black);
         }
         if(isim == true){
         doublechoice.setBackground(std_white);
//         doublechoice.setForeground(Color.black);
         panelv4b.add(doublechoice);
         }
// period of orbit 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    dtime = 0.001*pyrs; 

         thread = new Thread(this); 
         thread.start(); 
         istep = false; 
         repaint();
         istep=true; 
      } 

//      if(arg == "Start") { 
////         beep[1].play(); 
//         button1v.setLabel("Stop");
////         button1v.setBackground(new Color(0,255,0)); 
////         button2v.setBackground(new Color(200,100,100)); 
////         button3v.setBackground(new Color(200,100,100)); 
//         panelV.add(button1v); 
//         repaint();
////         panelV.add(button2v); 
////         panelV.add(button3v); 
//         if(isim == false){
//         doublechoice.setBackground(Color.black);
//         doublechoice.setForeground(Color.black);
//         }
//         if(isim == true){
//         doublechoice.setBackground(Color.white);
//         doublechoice.setForeground(Color.black);
//         }
//         thread = new Thread(this); 
//         thread.start(); 
//         istep = false; 
//         repaint();
//         istep=true; 
//      } 
 
        if(arg == "Stop"){ 
// you change the color and add the "new" button. weird!
         button1v.setLabel("Start");
//         button1v.setBackground(new Color(100,200,100)); 
//         button2v.setBackground(new Color(255,0,0)); 
         panelV.add(button1v); 
         repaint();
//         panelV.add(button2v); 
         thread = null; 
         repaint();
       } 

       if(arg == "About") {  

        helpframe = new HelpFrameP(
"This is a Java simulation of reported extrasolar planets.",
"The basic functions of the applet are as follows:",
"The choice menu at bottom right gives a choice of Earth, Jupiter, or a possible extrasolar planet.",
"'Start/Stop' begins and pauses the simulation.",
"'Reset' return the simulation to time=0.",
"'Orbit' draws the elliptical orbit of the planet.",
"'Grid' shows a calibrated length scale (in [AU]) centered on the system's c.o.g.",
"'Faster' and 'Slower' change the time step by a factor of two.",
"'Labels' attaches text to the star and planet.",
" The scrollbars let you design your own star-and-planet system and see how properties",
"     such as the geometry and period change with the system parameters.",
"     These parameters are the masses, semimajor axis (in [AU]) and orbital eccentricity.",
"     Their values and the orbital period are shown above the scrollbars and on the screen.",
"     (The choice window then blacks out, to indicate that you are not simulating a double from its list.)",
"A data window shows the elapsed time (in [yrs]), the star-planet separation (in [AU])",
"     and the x and y components of the star's velocity, which would be observed as a Doppler effect.",
"THE SIMULATION:",
"The planet is started at greatest separation (aphelion) at time=0 and its motion",
"is followed along it's elliptical trajectory using a fixed time step,",
"with orbit parameters taken either from stored data (for a real or reported planet)",
"or from the scrollbars.",
"",
"",
"                                                                       Java programming by Ted Barnes"
);

        helpframe.resize(520,500);
        helpframe.move(0,0);
        helpframe.show();
         istep = false;
         repaint();
         istep=true; 
      } 
// } 
  
        if(arg == "Reset") { 
         button1v.setLabel("Start");
        doublechoice.setBackground(Color.white);
        doublechoice.setForeground(Color.black);
        thread = null; 
        isim=true;
        time=0.0; 
        theta=0.0; 
        doublenumber = doublechoice.getSelectedIndex(); 
        astars  = adata[doublenumber]; 
        mass1 = masspdata[doublenumber];
        mass2 = masssdata[doublenumber];
        epsilon = epsdata[doublenumber]; 
        doublename = doublenamedata[doublenumber]; 
// period of orbit 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    dtime = 0.001*pyrs; 

//        iparams = true; 
        istep=false; 
        repaint(); 
        } 
 
 
       if(arg == "Orbit"){ 
         iorbit = !iorbit;  
         repaint(); 
       } 


         if(arg == "Grid"){ 
         igrid = !igrid; 
         repaint();
       } 
 
        if(arg == "Faster"){
         ifaster=true; 
       } 

        if(arg == "Slower"){
         islower=true; 
       } 

        if(arg == "Labels"){ 
         ilabels = !ilabels; 
         repaint(); 
        } 

 } 
   return true; 
} 
 
 
// my new stuff  
 
public void paint (Graphics g) { 
// 
Font font = new Font("Arial", Font.PLAIN, 11);
g.setFont(font);

double rsq,rreal,rcube,dvx,dvy,dxreal,dyreal; 
double tyears,tempf,tempc,tempk,veloc; 
int ixdraw,iydraw; 
String text2; 
String text[]  = new String[20]; 
text[3]  = "time =                     [yrs] "; 
 
// 
// first we draw sky then update positions 
// 
// work out some orbit length scales  
// to set display size variable "radscrn" 
 
    if(isim){ 
    g.setColor(std_yellow); 
    doublename = doublenamedata[doublenumber]; 
    g.drawString("Simulation of "+doublename+aftertext[doublenumber], 240,265); 
//    g.setColor(Color.red); 
//    g.drawString("distance = "+decimalPlace(0,distpcdata[doublenumber])+ "  [pc]", 240,180); 
    } 
 
    double ast1 = astars*mass2/(mass1+mass2); 
    double ast2 = astars*mass1/(mass1+mass2); 
    double dcog1max = ast1*(1.0+epsilon); 
    double dcog2max = ast2*(1.0+epsilon); 
    double dcogmax = Math.max(dcog1max,dcog2max); 
    while(dcogmax > rdisplaymax){ 
    rdisplaymax = 2.0*rdisplaymax; 
    rdisplaymin = 2.0*rdisplaymin; 
    radscrn     = 0.5*radscrn ; 
    } 
    while(dcogmax < rdisplaymin){ 
    rdisplaymax = 0.5*rdisplaymax; 
    rdisplaymin = 0.5*rdisplaymin; 
    radscrn     = 2.0*radscrn ; 
    } 
 
// now draw the orbits 
 
    if(iorbit == true){ 
    int orb1width = (int) (0.5*radscrn*( 2.0*ast1) ); 
    int orb1height= (int) (0.5*radscrn* (2.0*ast1*Math.sqrt(1.0-epsilon*epsilon)) ); 
    int orb1x0 = (int)(0.5*screenscale + 0.5*radscrn*(-ast1*(1.0-epsilon))); 
    int orb1y0 = (int)(0.5*screenscale - 0.5*radscrn*(ast1*Math.sqrt(1.0-epsilon*epsilon))); 
    g.setColor(Color.green); 
    g.drawOval(orb1x0,orb1y0,orb1width,orb1height); 
 
//    int orb2width = (int) (0.5*radscrn*( 2.0*ast2) ); 
//    int orb2height= (int) (0.5*radscrn* (2.0*ast2*Math.sqrt(1.0-epsilon*epsilon)) ); 
//    int orb2x0 = (int)(0.5*screenscale + 0.5*radscrn*(-ast2*(1.0+epsilon))); 
//    int orb2y0 = (int)(0.5*screenscale - 0.5*radscrn*(ast2*Math.sqrt(1.0-epsilon*epsilon))); 
//    g.drawOval(orb2x0,orb2y0,orb2width,orb2height); 
    } 
 
 
    if(ifaster){
    dtime=2.0*dtime;
    ifaster=false;
    }
    if(islower){
    dtime=0.5*dtime;
    islower=false;
    }

    xstarprev=0.0;
    ystarprev=0.0;
    if(time > 0.0) {
    xstarprev = xstar[2][1];
    ystarprev = xstar[2][2];
    }
 
// star positions are 
    double rstar1 = ast1*(1.0-epsilon*epsilon)/(1.0-epsilon*Math.cos(theta)); 
    xstar[1][1] = Math.cos(theta)*rstar1; 
    xstar[1][2] = Math.sin(theta)*rstar1; 
    xstar[2][1] = -(mass1/mass2)*xstar[1][1]; 
    xstar[2][2] = -(mass1/mass2)*xstar[1][2]; 

    dxstar = xstar[2][1] - xstarprev;
    dystar = xstar[2][2] - ystarprev;
    vxstar = dxstar/dtime;
    vystar = dystar/dtime;
    vxstarmps = vxstar * ratio_aupy_mps;
    vystarmps = vystar * ratio_aupy_mps;
 
// draw planet on the screen 
    g.setColor(Color.yellow); 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[1][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[1][2]); 

    g.setColor(std_gray1);
    g.drawLine(ixdraw-6,iydraw  ,ixdraw-4,iydraw  );
    g.drawLine(ixdraw+4,iydraw  ,ixdraw+6,iydraw  );
    g.drawLine(ixdraw  ,iydraw-6,ixdraw  ,iydraw-4);
    g.drawLine(ixdraw  ,iydraw+4,ixdraw,  iydraw+6);
    g.setColor(Color.white);
    g.fillOval(ixdraw-1,iydraw-1,2,2);
 
    if(ilabels == true){ 
    g.setColor(label1color[doublenumber]); 
    if(isim){
    if(doublenumber == 0){ g.drawString ("Earth", ixdraw+5, iydraw-5);   }
    if(doublenumber == 1){ g.drawString ("Jupiter", ixdraw+5, iydraw-5); }
    if(doublenumber >= 2){ g.drawString ("Planet", ixdraw+5, iydraw-5);  }
    }
    if(!isim){g.drawString ("Planet", ixdraw+5, iydraw-5);  }
    } 
// for repainting 
    ixreps1=ixdraw; 
    iyreps1=iydraw; 
 
// draw star  
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[2][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[2][2]); 
 
    int istarrad = (int) Math.max(2.0,4.0*radscrn/screenscale); 
    istarrad = Math.min(istarrad,4);
    g.drawImage(img2data[doublenumber],ixdraw-istarrad+1,iydraw-istarrad+1,2*istarrad,2*istarrad,this);
    if(ilabels == true){ 
    g.setColor(label2color[doublenumber]); 
    if(isim){
    if(doublenumber >= 2) {g.drawString (doublenamedata[doublenumber], ixdraw+5, iydraw-5); }
    if((doublenumber == 1) || (doublenumber == 0) ) {g.drawString ("Sun", ixdraw+5, iydraw-5); } 
    }
    if(!isim) {g.drawString ("Star", ixdraw+5, iydraw-5); }
    } 
    ixreps2=ixdraw; 
    iyreps2=iydraw; 
 
    if(istep == true){ 
    time  += dtime; 
    double dtheta=2.0*pi*(ast1/rstar1)*(ast1/rstar1)*Math.sqrt(1.0-epsilon*epsilon)*dtime/pyrs; 
    theta += dtheta; 
    } 
 
 
// draw axes  
    if(igrid == true){ 
    g.setColor(std_blue); 
    g.drawArc(mrquart,mrquart,mrhalf,mrhalf,0,360);
    g.drawArc(0,0,mrone,mrone,0,360);
    g.setColor(ai_textcolor); 
    g.drawLine(0,mrhalf,mrone,mrhalf); 
    g.drawLine(mrhalf,0,mrhalf,mrone); 
    g.drawLine(ix1, ticy1, ix1, ticy2); 
    g.drawLine(ix2, ticy1, ix2, ticy2); 
    g.drawLine(ix3, ticy1, ix3, ticy2); 
    g.drawLine(ix4, ticy1, ix4, ticy2); 
    g.drawLine(ix5, ticy1, ix5, ticy2); 
    g.drawLine(ticx1, iy1, ticx2, iy1); 
    g.drawLine(ticx1, iy2, ticx2, iy2); 
    g.drawLine(ticx1, iy3, ticx2, iy3); 
    g.drawLine(ticx1, iy4, ticx2, iy4); 
    g.drawLine(ticx1, iy5, ticx2, iy5);  
    double screenmagnif = ((double) screenscale) /( (double) radscrn ); 
    if(screenmagnif > 0.2){
    g.drawString(decimalPlace(4,(double) 0.5*screenmagnif)+" [AU]",3*mrquart+5,mrhalf-5);
    }
    g.drawString(decimalPlace(4,(double) screenmagnif)+" [AU]",mrone+5,mrhalf-5);
    } 
// end axis drawing 
 
// data drawing  

    if(time > 0.0){
    g.setColor(std_gray4); 
    g.fillRect(280,0,130,90);
    g.setColor(std_gray1); 
    g.drawRect(280,0,130,90);
    g.drawString("time = "+decimalPlace(2,time)+" [yrs]",             290,20); 
    double r12 = (1.0+mass1/mass2)*rstar1; 
    g.drawString("r_12 = "+decimalPlace(2,r12)+" [AU]",               290,40); 
    if(Math.abs(vxstarmps) <   10.0){
    g.drawString("vx(star) =  "+decimalPlace(2,vxstarmps)+" [m/sec]", 290,60);
    }
    if((Math.abs(vxstarmps) >= 10.0) && (Math.abs(vxstarmps) < 100.0) ){
    g.drawString("vx(star) =  "+decimalPlace(1,vxstarmps)+" [m/sec]", 290,60);
    }
    if(Math.abs(vxstarmps) >= 100.0){
    g.drawString("vx(star) =  "+decimalPlace(0,vxstarmps)+" [m/sec]", 290,60);
    }
    if(Math.abs(vystarmps) < 10.0){
    g.drawString("vy(star) =  "+decimalPlace(2,vystarmps)+" [m/sec]", 290,80);
    }
    if((Math.abs(vystarmps) >= 10.0) && (Math.abs(vystarmps) < 100.0) ){
    g.drawString("vy(star) =  "+decimalPlace(1,vystarmps)+" [m/sec]", 290,80);
    }
    if(Math.abs(vystarmps) >= 100.0){
    g.drawString("vy(star) =  "+decimalPlace(0,vystarmps)+" [m/sec]", 290,80);
    }
    }

// bc drawing 
    g.setColor(std_gray1); 
    g.drawString("Mass of planet",                430, 20); 
    g.drawString("Mass of star",                  440, 80); 
    g.drawString("Semimajor axis",                433,140); 
    g.drawString("Eccentricity",                  440,200); 
    double mplan = mass1/ratiojsun;
    g.drawString(decimalPlace(1,mplan)+" [MJup]", 440, 35); 
    g.drawString(decimalPlace(1,mass2)+" [Msun]", 440, 95); 
    g.drawString(decimalPlace(1,astars)+" [AU]",  445,155); 
    g.drawString(decimalPlace(2,epsilon),         455,215); 
    g.setColor(std_yellow);
    if(pyrs >= 0.1){
    g.drawString("orbital period = "+decimalPlace(2,pyrs+0.0001)+" [yrs]", 240,280);  
    }    
    if(pyrs < 0.1){
    g.drawString("orbital period = "+decimalPlace(3,pyrs+0.0001)+" [yrs]", 240,280);  
    }


//// bc drawing 
//    if(iparams == true){ 
//    g.setColor(Color.cyan); 
//    g.drawString("Mass of planet",    15,290); 
//    g.drawString("Mass of star",     120,290); 
//    g.drawString("Semimajor axis a", 225,290); 
//    g.drawString("Eccentricity",     330,290); 
//    double mplan = mass1/ratiojsun;
//    g.drawString(decimalPlace(3,mplan)+" [MJup]", 15,305); 
////    g.drawString(decimalPlace(3,mplanetjups[doublenumber])+" [MJup]", 15,305); 
//    g.drawString(decimalPlace(2,mass2)+" [Msun]",120,305); 
//    g.drawString(decimalPlace(3,astars)+" [AU]", 225,305); 
//    g.drawString(decimalPlace(3,epsilon),        330,305); 
//    g.drawString("Orbital period = "+decimalPlace(3,pyrs)+" [yrs]", 250,240); 
//    } 
 
//end of paint() 
} 
 
// Dr.Guidry's patented truncatator 
 
public String decimalPlace(int nright, double number) { 
   double n = number; 
   String tright2 =""; 
   String total=String.valueOf(n); 
   int nperiod = total.indexOf("."); 
   if(nperiod == 0 || nperiod == -1) {return total;} 
   String tleft=total.substring(0,nperiod); 
   String tright=total.substring(nperiod); 
   int temp1=0, temp2=nright+1; 
   if(tright.length() > nright) { 
      try{tright2=tright.substring(temp1,temp2);} 
          catch(StringIndexOutOfBoundsException e) 
      { ; } 
   } 
   else { 
      tright2=tright; 
   } 
   return tleft+tright2; 
}  
 
 
/* 
 * called when the applet is started 
 * create a new instance of Thread and start it 
 */ 
public void start() { 
 
        if(thread == null) { 
                thread = new Thread(this); 
                thread.start(); 
        } 
} 
 
/* 
 * called when the applet is stopped 
 * stops the thread 
 */ 
public void stop() { 
 
	thread = null; 
} 
 
/* 
 * the thread itself 
 * sleeps for (arg) ms and forces a repaint 
 */ 
public void run() { 
 
	while (thread != null) {  
                try { 
                        Thread.sleep(15); 
                } catch (InterruptedException e) { } 
                  repaint();
	} 
	thread = null; 
} 
 
/** 
 * override the default update method to avoid 
 * flickering caused by unnecessary erasing of the applet panel 
 * @param g - destination graphics object 
 */ 
public void update(Graphics g) { 
     Graphics offScreenGraphics = offScreenImage.getGraphics();
     offScreenGraphics.setColor(getBackground());
     offScreenGraphics.fillRect(0,0,size().width,size().height);
     offScreenGraphics.setColor(g.getColor());
     paint(offScreenGraphics);
     g.drawImage(offScreenImage,0,0,this);
}
// 
/** 
 * application entry point 
 * not used when run as an applet 
 * create a new window frame and add the applet inside 
 * @param args[] - command line arguments 
 */ 
public static void main (String args[]) { 
 
        Frame f = new Frame ("Planet"); 
        Planet system = new Planet (); 
   
//        f.resize (210, 230); 
        f.resize (100, 100); 
        f.add ("Center", system); 
	f.show (); 
        system.init (); 
        system.start (); 
} 
} 
 
class HelpFrameP extends Frame
{
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
public String hstringtest;
public String textb[] = new String[31];

HelpFrameP(String h0, String h1, String h2, String h3, String h4, String h5,
String h6, String h7, String h8, String h9, String h10, String h11,
String h12, String h13, String h14, String h15, String h16, String h17, String h18,
String h19, String h20, String h21, String h22, String h23)
  {
  hstringtest   = h0;
  textb[1]      = h1;
  textb[2]      = h2;
  textb[3]      = h3;
  textb[4]      = h4;
  textb[5]      = h5;
  textb[6]      = h6;
  textb[7]      = h7;
  textb[8]      = h8;
  textb[9]      = h9;
  textb[10]     = h10;
  textb[11]     = h11;
  textb[12]     = h12;
  textb[13]     = h13;
  textb[14]     = h14;
  textb[15]     = h15;
  textb[16]     = h16;
  textb[17]     = h17;
  textb[18]     = h18;
  textb[19]     = h19;
  textb[20]     = h20;
  textb[21]     = h21;
  textb[22]     = h22;
  textb[23]     = h23;
  }
  public void paint(Graphics g)
     {
// set up a 520x500 size data frame
     int fw = 520;
     int fh = 500;
//     resize(fw,fh);
     Font framefont = new Font("Arial", Font.PLAIN, 10);
     g.setFont(framefont);
     g.setColor(Color.black);
     g.fillRect(0,0,fw,fh);
     g.setColor(Color.green);
     g.drawString(hstringtest,30,50);
     g.setColor(Color.cyan);
     int ihwrite = 80;
     g.drawString("FUNCTIONS:",30,ihwrite);
     int itextloop;
     for(itextloop=0; itextloop<16; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }
     ihwrite+=15;
     g.setColor(std_yellow);
     for(itextloop=16; itextloop<31; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }

     }

  public boolean handleEvent(Event evt)
     {
     switch(evt.id)
     {
        case Event.WINDOW_DESTROY:
        dispose();
        return true;
     }
     return false;
     }

}

// thats all folks
