// Roche.java 
 
// a generic double star rotating 
 
// 
//  class  method       qualifiers 
// 
//    Roche             p A R
//         init         p v 
//         paint        p v 
//         start        p v 
//         stop         p v 
//         run          p v 
//         update       p v     may be commented out 
//         main         p s v   not used as applet 
 
 
import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.util.Date; 
 
 
public class Roche extends Applet implements Runnable { 
 
Panel panelT = new Panel(); 
Panel panelH = new Panel(); 
Panel panelV = new Panel(); 
// new nested scrollbar panels
Panel panelv1 = new Panel();
Panel panelv2 = new Panel();
Panel panelv3 = new Panel();
Panel panelv4 = new Panel();
Panel panelv5 = new Panel();
//
Button button0v,button1v,button2v,button3v,button4v,button5v,button6v,
button7av,button7bv,button8v,button9v,button10v,button11v;
Button buttontest;
Scrollbar sm1,sm2,sa,seps;
Scrollbar scrolltest;
Choice doublechoice;
HelpFrameR helpframe;

// the instance of Thread for checking the time periodically 
Thread thread = null; 
 
// planet and star setup data 
// funny numbers are because it uses first index = 0 
// but i use 1,2,...,n_objects 
// number of doubles stored 
public int ndoubles; 
public double parallaxdata[]   = new double[21]; 
public double aarcsecdata[]   = new double[21]; 
public double adata[]   = new double[21]; 
public double m12ratiodata[]  = new double[21]; 
public double magadata[] = new double[21];
public double magbdata[] = new double[21];
public double msum[]  = new double[21];
public double epsdata[] = new double[21]; 
public double perioddata[] = new double[21]; 
public String doublenamedata[] = new String[21]; 
public String aftertext[] = new String[21]; 
public String sstar1[] = new String[21];
public String sstar2[] = new String[21];
public double distpcdata[]   = new double[21]; 
public String doublename; 
public Image img1data[] = new Image[21]; 
public Image img2data[] = new Image[21]; 
private Image offScreenImage;

public Color scrollbarcolorH;
public Color scrollbarcolorV;
public Color label1color[] = new Color[21];
public Color label2color[] = new Color[21]; 
public Color labelcolor[] = new Color[21]; 
public Color ai_textcolor = new Color(144,196,196);
public Image imglibdata[] = new Image[21]; 
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
public int doublenumber=0; 
public double mass1; 
public double mass2; 
public double astars; 
public double epsilon; 
public int nstars  =3; 
public int ncoords =4; 
public double xstar[][] = new double[nstars][ncoords]; 
public double vstar[][] = new double[nstars][ncoords]; 
 
// screen setup 
Image imgstar[] = new Image[nstars]; 
public double screenscale; 
public double radscrn; 
public double rdisplaymax=1.01; 
public double rdisplaymin=0.49; 
public static double pi=3.14159265358979323; 
 
// array declarations that actually work: 
//int numvals=30; 
//double numbers[][] = new double[numvals][numvals]; 
//float numbers[] = new float[30]; 
 
public double dtime; 
public double time = 0.0; 
public double theta=0.0; 
 
// for axis and data drawing 
public int ipalette=1;
// istep=false allows screen clear or adjust w/o stepping time 
public boolean iroche  = false;
public boolean isim    = true;
public boolean istep   = false; 
public boolean igrid   = false;
public boolean izoomin = false;
public boolean izoomout= false;
public boolean ilabels = false; 
public boolean iorbits = true; 
public double r1try,r2try,rstar2,r12sum,xtemp,vcontour,vdist,vdistprev,vpot,passcontour;
public double xtry,ytry,x1try,y1try,x2try,y2try;
public int ix1,ix2,ix3,ix4,ix5,iy1,iy2,iy3,iy4,iy5;
public int ix,iy;
public int ticx1,ticx2,ticy1,ticy2,mrone,mrhalf,mrquart; 
//// sounds 
//AudioClip beep[] = new AudioClip[10]; 
 
public void init(){ 
 
// load generic star images 

    offScreenImage = createImage(size().width,size().height);

    imgstar[1] = getImage(getDocumentBase(),"sun_yellow.jpg"); 
    imgstar[2] = getImage(getDocumentBase(),"sun_blue.jpg"); 
 
    imglibdata[1] = getImage(getDocumentBase(),"star_O.jpg"); 
    imglibdata[2] = getImage(getDocumentBase(),"star_B.jpg"); 
    imglibdata[3] = getImage(getDocumentBase(),"star_A.jpg"); 
    imglibdata[4] = getImage(getDocumentBase(),"star_F.jpg"); 
    imglibdata[5] = getImage(getDocumentBase(),"star_G.jpg"); 
    imglibdata[6] = getImage(getDocumentBase(),"star_K.jpg"); 
    imglibdata[7] = getImage(getDocumentBase(),"star_M.jpg"); 
    imglibdata[8] = getImage(getDocumentBase(),"star_WD.jpg"); 

// set up scrollbar colors

    scrollbarcolorH = new Color(0,0,0);
    scrollbarcolorV = new Color(0,0,0);

// set up label colors

    labelcolor[1] = new Color(0,255,255);
    labelcolor[2] = new Color(200,255,255);
    labelcolor[3] = new Color(244,244,244);
    labelcolor[4] = new Color(255,255,164);
    labelcolor[5] = new Color(255,255,0);
    labelcolor[6] = new Color(255,148,0);
    labelcolor[7] = new Color(255,0,0);
    labelcolor[8] = std_gray2;
 
// instances of double stars (yuk yuk) 

    int i=-1;

    i+=1;
    doublenamedata[i]    = "Alpha Centauri";
    aftertext     [i]    = " (G2V and K0V)";
    img1data      [i]    = imglibdata[5]; 
    img2data      [i]    = imglibdata[6];
    parallaxdata  [i]    = 0.754; 
    perioddata    [i]    = 79.92; 
    aarcsecdata   [i]    = 17.515; 
    epsdata       [i]    = 0.516; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    = -0.04;
    magbdata      [i]    =  1.17;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[5];
    label2color   [i]    = labelcolor[6];
//  
// type G2V K0V, mags -0.04 1.17 
// RA 14 39.6 dec -60 50 



    i+=1;
    doublenamedata[i]    = "Sirius";
    aftertext     [i]    = " (A1V and white dwarf)";
    img1data      [i]    = imglibdata[3]; 
    img2data      [i]    = imglibdata[8]; 
    parallaxdata  [i]    = 0.374; 
    perioddata    [i]    = 50.09; 
    aarcsecdata   [i]    = 7.500; 
    epsdata       [i]    = 0.592; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    m12ratiodata  [i]    = 2.1; 
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[3];
    label2color   [i]    = labelcolor[8];
// aka alpha CMa, 
// type A1V DA, mags -1.46 8.49 
// RA 6 45.1 dec -16 43 


    i+=1;
    doublenamedata[i]    = "Procyon";
    aftertext     [i]    = " (F5IV and white dwarf)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[8]; 
    parallaxdata  [i]    = 0.283; 
    perioddata    [i]    = 40.65; 
    aarcsecdata   [i]    = 4.548; 
    epsdata       [i]    = 0.40; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    m12ratiodata  [i]    = 5.; 
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[8];
// aka alpha CMi, 
// type F5IV (WD), mags 0.35 10.3 
// RA 7 39.3 dec 05 13 


    i+=1;
    doublenamedata[i]    = "Capella";
    aftertext     [i]    = " (G0III and G5III)";
    img1data      [i]    = imglibdata[5]; 
    img2data      [i]    = imglibdata[5]; 
    parallaxdata  [i]    = 1.0/13.; 
// took parallax from official distance in SkyCat 
    perioddata    [i]    = 0.28481; 
    aarcsecdata   [i]    = 0.055; 
    epsdata       [i]    = 0.0; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  0.6;
    magbdata      [i]    =  1.1;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 13.; 
    label1color   [i]    = labelcolor[5];
    label2color   [i]    = labelcolor[5];
// aka alpha Aurigae, 
// type G0III G5III, mags 0.6 1.1 
// RA 5 16 41.3 dec 45 59 53 


    i+=1;
    doublenamedata[i]    = "Porrima";
    aftertext     [i]    = " (F0V and F0V)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[4]; 
    parallaxdata  [i]    = 0.094; 
    perioddata    [i]    = 171.37; 
    aarcsecdata   [i]    = 3.746; 
    epsdata       [i]    = 0.881; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  3.48;
    magbdata      [i]    =  3.50;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[4];
// aka gamma Vir, 
// type F0V F0V, mags 3.48 3.50 
// RA 12 41.7 dec -1 27 



    i+=1;
    doublenamedata[i]    = "70 Ophiuchi";
    aftertext     [i]    = " (K0V)";
    img1data      [i]    = imglibdata[6]; 
    img2data      [i]    = imglibdata[6]; 
    parallaxdata  [i]    = 0.193; 
    perioddata    [i]    = 88.13; 
    aarcsecdata   [i]    = 4.545; 
    epsdata       [i]    = 0.50; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  4.21;
    magbdata      [i]    =  6.00;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    m12ratiodata  [i]    = 2.; 
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[6];
    label2color   [i]    = labelcolor[6];
//  
// type K0V (not sep), mags 4.21 6.00 
// RA 10 05.5 dec 02 30 

    i+=1;
    doublenamedata[i]    = "delta Equulei";
    aftertext     [i]    = " (F7V and F7V)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[4]; 
    parallaxdata  [i]    = 0.053; 
    perioddata    [i]    =  5.7; 
    aarcsecdata   [i]    =  0.26; 
    epsdata       [i]    =  0.42; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  5.2;
    magbdata      [i]    =  5.3;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[4];
//  
// type F7V F7V, mags 5.2 5.3 
// RA 21 14.5 dec 10 00 

    i+=1;
    doublenamedata[i]    = "tau Cygni";
    aftertext     [i]    = " (F0IV)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[4]; 
    parallaxdata  [i]    = 0.046; 
    perioddata    [i]    = 49.9; 
    aarcsecdata   [i]    =  0.88; 
    epsdata       [i]    =  0.25; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  3.82;
    magbdata      [i]    =  6.42;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[4];
//  
// type F0IV (not sep), mags 3.82 6.42 
// RA 21 14.5 dec 10 00 

    i+=1;
    doublenamedata[i]    = "85 Peg"; 
    aftertext     [i]    = " (G2V)";
    img1data      [i]    = imglibdata[5]; 
    img2data      [i]    = imglibdata[5]; 
    parallaxdata  [i]    = 0.081; 
    perioddata    [i]    = 26.27; 
    aarcsecdata   [i]    = 0.83; 
    epsdata       [i]    = 0.38; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  5.84;
    magbdata      [i]    =  8.88;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 12.; 
    label1color   [i]    = labelcolor[5];
    label2color   [i]    = labelcolor[5];
// type G2V, mags 5.84 8.88 
// RA 0 02 10.1   DEC 27  04  56 

    i+=1;
    doublenamedata[i]    = "48 Cas"; 
    aftertext     [i]    = " (A4V)";
    img1data      [i]    = imglibdata[3]; 
    img2data      [i]    = imglibdata[3]; 
    parallaxdata  [i]    = 0.032; 
    perioddata    [i]    = 60.44; 
    aarcsecdata   [i]    = 0.653; 
    epsdata       [i]    = 0.345; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  4.70;
    magbdata      [i]    =  6.37;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 33.; 
    label1color   [i]    = labelcolor[3];
    label2color   [i]    = labelcolor[3];
// aka ADS1598 
// type A4V, mags 4.70 6.37 
// RA 2 01 57.3  dec 70 54 26 

    i+=1;
    doublenamedata[i]    = "57 And"; 
    aftertext     [i]    = " (B8V and A0V)";
    img1data      [i]    = imglibdata[3]; 
    img2data      [i]    = imglibdata[3]; 
    parallaxdata  [i]    = 1.0/37.; 
    perioddata    [i]    = 61.1; 
    aarcsecdata   [i]    = 0.296; 
    epsdata       [i]    = 0.93; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i];  
    magadata      [i]    =  5.5;
    magbdata      [i]    =  6.3;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 37.; 
    label1color   [i]    = labelcolor[3];
    label2color   [i]    = labelcolor[3];
// aka gamma2 And, 
// type B8V, A0V, mags 5.5 6.3 
// RA 2 03 54.7 dec 42 19 51 
// surely the parallax of 0.005" quoted in SkyCat2 is a typo? 
// i changed it to 1/d(pc) of Vol.I by hand 

    i+=1;
    doublenamedata[i]    = "epsilon Ceti"; 
    aftertext     [i]    = " (F5IV-V)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[4]; 
    parallaxdata  [i]    = 0.059; 
    perioddata    [i]    = 2.667; 
    aarcsecdata   [i]    = 0.108; 
    epsdata       [i]    = 0.27; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  5.8;
    magbdata      [i]    =  5.8;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 1.0/parallaxdata[i]; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[4];
// aka 83 Ceti, 
// type F5IV-V, mags 5.8  5.8 
// RA 2 39.6 dec -11 52 
 


    i+=1;
    doublenamedata[i]    = "HD3443"; 
    aftertext     [i]    = " (G5V)";
    img1data      [i]    = imglibdata[5]; 
    img2data      [i]    = imglibdata[5]; 
    parallaxdata  [i]    = 0.070; 
    perioddata    [i]    = 25.0000001; 
    aarcsecdata   [i]    = 0.670; 
    epsdata       [i]    = 0.22; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  6.3;
    magbdata      [i]    =  6.4;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 13.; 
    label1color   [i]    = labelcolor[5];
    label2color   [i]    = labelcolor[5];
// aka ADS520, in Cetus      
// type G5V, mags 6.3 6.4 
// RA 0 37 20.6   DEC -24 46 02  

    i+=1;
    doublenamedata[i]    = "HD8556"; 
    aftertext     [i]    = " (F3V and F4V)";
    img1data      [i]    = imglibdata[4]; 
    img2data      [i]    = imglibdata[4]; 
    parallaxdata  [i]    = 0.023; 
    perioddata    [i]    = 16.14; 
    aarcsecdata   [i]    = 0.188; 
    epsdata       [i]    = 0.22; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  6.6;
    magbdata      [i]    =  6.8;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 42.; 
    label1color   [i]    = labelcolor[5];
    label2color   [i]    = labelcolor[5];
// aka ADS1123, in Cetus 
// type F3V, F4V, mags 6.6 6.8 
// RA 1 24 20.5  dec -6 54 53 

    i+=1;
    doublenamedata[i]    = "HD9770"; 
    aftertext     [i]    = " (K3V)";
    img1data      [i]    = imglibdata[6]; 
    img2data      [i]    = imglibdata[6]; 
    parallaxdata  [i]    = 0.052; 
    perioddata    [i]    = 4.559; 
    aarcsecdata   [i]    = 0.171; 
    epsdata       [i]    = 0.316; 
    adata         [i]    =  aarcsecdata[i]/parallaxdata[i]; 
    magadata      [i]    =  7.8;
    magbdata      [i]    =  7.9;
// this has mass scaling like lum^0.3. assumes sim main seq spectral type
    m12ratiodata  [i]    = Math.exp( -0.9210 * 0.3 * (magadata[i]-magbdata[i]));
    distpcdata    [i]    = 15.; 
    label1color   [i]    = labelcolor[4];
    label2color   [i]    = labelcolor[4];
// aka delta 31, in Sculptor 
// type K3V, mags 7.8 7.9 
// RA 1 35 00.8  dec -29 54 36 



    ndoubles=i+1;
 
    for(int idbl=0; idbl<ndoubles; ++idbl){ 
    sstar1[idbl] = " "+doublenamedata[idbl]+" A";
    sstar2[idbl] = " "+doublenamedata[idbl]+" B";
    msum[idbl] = adata[idbl]*adata[idbl]*adata[idbl]/(perioddata[idbl]*perioddata[idbl]); 
    } 
 

this.setBackground(Color.black); 
//this.setLayout(new BorderLayout()); 
this.setLayout(null); 

      panelV.setLayout(null);
      panelV.setBounds(0,320,520,20);
// defines buttons 
    button1v = new Button("Start"); 
    button3v = new Button("Reset"); 
    button4v = new Button("Orbits"); 
    button6v = new Button("Grid");
    button7av= new Button("ZoomIn");
    button7bv= new Button("ZoomOut");
    button8v = new Button("Labels");  
    button10v= new Button("Roche");
    button0v = new Button("About"); 
// sets button bounds 
    button1v.setBounds (  0,0,50,20); 
    button3v.setBounds ( 58,0,50,20); 
    button4v.setBounds (116,0,50,20); 
    button6v.setBounds (174,0,50,20); 
    button7av.setBounds(232,0,50,20); 
    button7bv.setBounds(290,0,50,20); 
    button8v.setBounds (348,0,50,20);
    button10v.setBounds(406,0,50,20); 
    button0v.setBounds (464,0,50,20); 
// color buttons
    if(ipalette==1){
    button0v.setBackground(std_gray2);     
    button1v.setBackground(std_gray2); 
    button3v.setBackground(std_gray2); 
    button4v.setBackground(std_gray2); 
    button6v.setBackground(std_gray2); 
    button7av.setBackground(std_gray2); 
    button7bv.setBackground(std_gray2); 
    button8v.setBackground(std_gray2); 
    button10v.setBackground(std_gray2); 
}
    if(ipalette==3){
    button0v.setBackground(new Color(200,000,200)); 
    button1v.setBackground(new Color(100,200,100)); 
    button3v.setBackground(new Color(200,100,100)); 
    button4v.setBackground(new Color(100,100,255)); 
    button6v.setBackground(new Color(100,100,255)); 
    button7av.setBackground(new Color(100,100,255)); 
    button7bv.setBackground(new Color(100,100,255)); 
    button8v.setBackground(Color.gray); 
    button10v.setBackground(new Color(100,100,255)); 
}
 
// adds buttons 
    panelV.add(button1v); 
    panelV.add(button3v); 
    panelV.add(button4v); 
    panelV.add(button6v); 
    panelV.add(button7av); 
    panelV.add(button7bv); 
    panelV.add(button8v); 
    panelV.add(button10v); 
    panelV.add(button0v); 
    add(panelV);


// new panel test
      panelv1.setLayout(null);
      panelv1.setBounds(420,40,100,15);
      add(panelv1);
// for future ref. this is how you add a nested button
//      buttontest = new Button();
//      buttontest.setLabel("Test");
//      buttontest.setBounds(10,10,40,20);
//      buttontest.setBackground(new Color(100,100,255));
//      panelv1.add(buttontest);
      sm1 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,101); 
// nest a scrollbar in the panel
      sm1.setBounds(0,0,100,15);
      sm1.setBackground(std_gray2);
      panelv1.add(sm1);

      panelv2.setLayout(null);
      panelv2.setBounds(420,100,100,15);
      add(panelv2);
      sm2 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,101);
      sm2.setBounds(0,0,100,15);
      sm2.setBackground(std_gray2);
      panelv2.add(sm2);

      panelv3.setLayout(null);
      panelv3.setBounds(420,160,100,15);
      add(panelv3);
      sa = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,501);
      sa.setBounds(0,0,100,15);
      sa.setBackground(std_gray2);
      panelv3.add(sa);

      panelv4.setLayout(null);
      panelv4.setBounds(420,220,100,15);
      add(panelv4);
      seps = new Scrollbar (Scrollbar.HORIZONTAL,0,1,0,96);
      seps.setBounds(0,0,100,15);
      seps.setBackground(std_gray2);
      panelv4.add(seps);

      panelv5.setLayout(null);
      panelv5.setBounds(410,280,110,20);
      panelv5.setBackground(Color.black);
      add(panelv5);
// add choicepanel 
      doublechoice = new Choice();
      doublechoice.setBounds(0,0,110,20);
      doublechoice.setBackground(std_white);
// add doubles to choicepanel
      for(int idbl=0; idbl<ndoubles; ++idbl){
      doublechoice.addItem(doublenamedata[idbl]);
      } 
      panelv5.add(doublechoice);
 
// needed for axis drawing 
    Dimension d = size(); 
    screenscale= 0.8 * (double) d.height; 
    radscrn=screenscale; 
    mrone = (int) screenscale; 
    mrhalf= (int) (0.5*screenscale); 
    mrquart=(int) (0.25*screenscale);  
    ticy1= (int) (0.48*screenscale); 
    ticy2= (int) (0.52*screenscale); 
    ix1=0; 
    ix2= mrquart; 
    ix3= mrhalf; 
    ix4= 3*mrquart; 
    ix5= mrone; 
    ticx1= ticy1; 
    ticx2= ticy2; 
    iy1=0; 
    iy2= mrquart; 
    iy3= mrhalf; 
    iy4= 3*mrquart; 
    iy5= mrone; 
 
// setup start coords and veloc 
    time=0.0; 
    theta=0.0; 
// set sliders to initial double values
    doublenumber = doublechoice.getSelectedIndex(); 
    astars  = adata[doublenumber]; 
    mass1    = msum[doublenumber]*m12ratiodata[doublenumber]/(1.0+m12ratiodata[doublenumber]); 
    mass2    = msum[doublenumber]                           /(1.0+m12ratiodata[doublenumber]); 
    epsilon = epsdata[doublenumber]; 
    doublename = doublenamedata[doublenumber]; 
    sm1.setValue( (int) (10.0*mass1) );
    sm2.setValue( (int) (10.0*mass2) );
    sa.setValue(  (int) (10.0*astars));
    seps.setValue((int) (100.0*epsilon));

 
////  get sounds 
//    String name1,name2; 
//    name1 = "drip.au"; 
//    showStatus("Getting "+name1); 
//    beep[1] = getAudioClip(getCodeBase(),name1); 
//    beep[1].play(); 
//    name2 = "spacemusic.au"; 
//    showStatus("Getting "+name2); 
//    beep[2] = getAudioClip(getCodeBase(),name2); 
////    beep[2].play(); 
 
} 
 
// scrollbars 
 
public boolean handleEvent(Event evt){ 
   if(evt.target instanceof Scrollbar){
      thread = null; 
      isim=false; 
      sstar1[doublenumber]=" Star A";
      sstar2[doublenumber]=" Star B";
      time=0.0; 
      theta=0.0; 
      mass1 = 0.1*(double) (sm1.getValue()); 
      mass2 = 0.1*(double) (sm2.getValue()); 
      astars= 0.1*(double) (sa.getValue()); 
      epsilon=0.01*(double) (seps.getValue()); 
      istep  = false; 
      doublechoice.setBackground(Color.black);
      doublechoice.setForeground(Color.black);
//      panelv5.add(doublechoice);
      button1v.setLabel("Start");
      repaint(); 
      return true; 
   }
   else 
   { 
      boolean result = super.handleEvent(evt); 
      return result; 
   } 
} 
 
 
public boolean action(Event evt, Object arg){ 
 
 if(evt.target.equals (doublechoice)){ 
    thread = null; 
    if(ipalette==3){
        button1v.setBackground(new Color(100,200,100)); 
        button3v.setBackground(new Color(200,100,100)); 
    panelV.add(button1v);  
    panelV.add(button3v); 
    }
    doublechoice.setBackground(std_white);
    doublechoice.setForeground(Color.black);
    panelv5.add(doublechoice);
    isim=true; 
    time=0.0; 
    theta=0.0; 
    doublenumber = doublechoice.getSelectedIndex(); 
    astars  = adata[doublenumber]; 
    mass1    = msum[doublenumber]*m12ratiodata[doublenumber]/(1.0+m12ratiodata[doublenumber]); 
    mass2    = msum[doublenumber]                           /(1.0+m12ratiodata[doublenumber]); 
    epsilon = epsdata[doublenumber]; 
    doublename = doublenamedata[doublenumber];
    sstar1[doublenumber] = " "+doublenamedata[doublenumber]+" A";
    sstar2[doublenumber] = " "+doublenamedata[doublenumber]+" B";
    sm1.setValue( (int) (10.0*mass1) );
    sm2.setValue( (int) (10.0*mass2) );
    sa.setValue(  (int) (10.0*astars));
    seps.setValue((int) (100.0*epsilon));
    istep=false; 
    button1v.setLabel("Start");
    repaint(); 
    } 
 
 if(evt.target instanceof Button){ 
 
       if(arg == "About") { 
// ereiamjh
        helpframe = new HelpFrameR(ipalette,
"This is a straightforward generalization of the double star applet to show Roche lobes.",
"The basic functions of the applet are as follows:",
"The choice menu at bottom right gives a list of some doubles with accurately known orbits.",
"The data window at top shows the elapsed time (in [yrs]) and the separation between stars (in [AU]).",
"The text gives the system's name, distance to Earth (in parsecs, [pc]) and orbital period ([yrs]).",
"'Start/Stop' begins and halts the simulation.",
"",
"'Reset' return the simulation to time=0.",
"'Orbits' highlights the elliptical orbits followed by the components of the double.",
"'Grid' shows a length scale (in [AU]), centered on the stars' c.o.g.",
"'ZoomIn' and 'ZoomOut' change the display scale by a factor of two.",
"'Labels' attaches names to the stars.",
"'Roche' shows the instantaneous Roche lobes for the system.",
"By using the scrollbars at right you can design your own double star system",
"and see how the properties (such as the geometry and period) change.",
"(The choice window then blacks out, to indicate that you are not simulating a double from its list.)",
" ",
"THE SIMULATION:",
"The stars are started at greatest separation (apoastron) at time=0, and their motion",
"is followed through simple elliptical trajectories using a fixed time step,",
"with orbit parameters taken either from stored data (for a real double)",
"or from the scrollbars. For chosen doubles, ma+mb is known from Kepler's Law,",
"but ma/mb is only estimated, as (luminosity(a/b))^0.3 if of similar spectral type.",
"",
"                                                                       Java programming by Ted Barnes"
);

        helpframe.resize(520,520);
        helpframe.move(0,0);
        helpframe.show();
         istep = false;
         repaint();
         istep=true; 
      } 
 

      if(arg == "Start") {
//         beep[1].play(); 
//         button1v.setBackground(new Color(0,255,0)); 
//         button2v.setBackground(new Color(200,100,100)); 
//         button3v.setBackground(new Color(200,100,100)); 
         button1v.setLabel("Stop");
         panelV.add(button1v); 
         if(isim == false){
         doublechoice.setBackground(Color.black);
         doublechoice.setForeground(Color.black);
         }
         if(isim == true){
         doublechoice.setBackground(std_white);
         doublechoice.setForeground(Color.black);
         panelv5.add(doublechoice);
         }


         thread = new Thread(this); 
         thread.start(); 
         istep = false; 

         repaint();
         istep=true; 
      } 

       if(arg == "Roche") { 
         iroche=!iroche;  
         if(ipalette==3){
         if(iroche) { button10v.setBackground(new Color(100,100,255));}
         if(!iroche){ button10v.setBackground(Color.gray);}
         panelV.add(button10v);
        }
        repaint();
        }
 
 
//       if(arg == "music") { 
//         beep[2].loop(); 
//         button10v.setLabel("enough!"); 
//       } 
// 
//       if(arg == "enough!") { 
//         beep[2].stop(); 
//         button10v.setLabel("music"); 
//       } 
 
        if(arg == "Reset") { 
        if(ipalette==3){
        button1v.setBackground(new Color(100,200,100)); 
        button3v.setBackground(new Color(200,100,100)); 
        panelV.add(button3v); 
        }
        button1v.setLabel("Start");
        panelV.add(button1v); 
        doublechoice.setBackground(std_white);
        doublechoice.setForeground(Color.black);
        panelv5.add(doublechoice);
        repaint();
        thread = null; 
        isim=true;
        time=0.0; 
        theta=0.0; 
        doublenumber = doublechoice.getSelectedIndex(); 
        sstar1[doublenumber] = " "+doublenamedata[doublenumber]+" A";
        sstar2[doublenumber] = " "+doublenamedata[doublenumber]+" B";
        astars  = adata[doublenumber]; 
        mass1    = msum[doublenumber]*m12ratiodata[doublenumber]/(1.0+m12ratiodata[doublenumber]); 
        mass2    = msum[doublenumber]                           /(1.0+m12ratiodata[doublenumber]); 
        epsilon = epsdata[doublenumber]; 
        doublename = doublenamedata[doublenumber]; 
        istep=false; 
        repaint(); 
        } 
 
       if(arg == "Stop"){ 
         button1v.setLabel("Start");
         panelV.add(button1v); 
         thread = null; 
         istep=false; 
         repaint();
       } 
 
       if(arg == "Orbits"){ 
         iorbits = !iorbits; 
        if(ipalette == 3){
        if(iorbits == false){
        button4v.setBackground(Color.gray);
        button4v.setForeground(Color.black);
        }
        if(iorbits == true) 
        { 
        button4v.setBackground(new Color(100,100,255)); 
        button4v.setForeground(Color.black); 
        } 
        panelV.add(button4v);
        } 
         repaint(); 
       } 
 
       if(arg == "Grid"){ 
         igrid = !igrid; 
         if(ipalette==3){
         if(igrid == false) 
         { 
         button6v.setBackground(Color.gray); 
         } 
         if(igrid == true) 
         { 
         button6v.setBackground(new Color(100,100,255)); 
         button6v.setForeground(Color.black); 
         } 
         panelV.add(button6v); 
         }
         repaint(); 
       } 

       if(arg == "ZoomIn"){ 
         izoomin = true;
         repaint(); 
       }

       if(arg == "ZoomOut"){ 
         izoomout = true;
         repaint(); 
       } 
 
         if(arg == "Labels"){ 
         ilabels = !ilabels; 
         if(ipalette==3){
         if(ilabels == false) 
         { 
         button8v.setBackground(Color.gray); 
         } 
         if(ilabels == true) 
         { 
         button8v.setBackground(new Color(100,100,255)); 
         button8v.setForeground(Color.black); 
         } 
         panelV.add(button8v); 
         }
         repaint(); 
        } 

} 
   return true; 
} 
 
 
// my new stuff  
 
public void paint (Graphics g) { 

Font font = new Font("Arial", Font.PLAIN, 11);
g.setFont(font);
 
double rsq,rreal,rcube,dvx,dvy,dxreal,dyreal; 
double pyrs,tyears,tempf,tempc,tempk,veloc; 
int ixdraw,iydraw; 
String text2; 
String text[]  = new String[20]; 
text[3]  = "time =                     [yrs] "; 
text[4]  = "d_cog =                  [AU]"; 
text[5]  = "veloc ="; 
text[6]  = "[km/sec]"; 
text[11] = "[AU]"; 
 
// 
// first we draw sky then update positions 
// 
// work out some orbit length scales  
// to set display size variable "radscrn" 
 
 
    double ast1 = astars*mass2/(mass1+mass2); 
    double ast2 = astars*mass1/(mass1+mass2); 
    double dcog1max = ast1*(1.0+epsilon); 
    double dcog2max = ast2*(1.0+epsilon); 
    double dcogmax = Math.max(dcog1max,dcog2max); 

    if(isim){
    while(dcogmax > rdisplaymax){
    rdisplaymax = 2.0*rdisplaymax; 
    rdisplaymin = 2.0*rdisplaymin; 
    radscrn     = 0.5*radscrn ; 
    } 
    while(dcogmax < rdisplaymin){ 
    rdisplaymax = 0.5*rdisplaymax; 
    rdisplaymin = 0.5*rdisplaymin; 
    radscrn     = 2.0*radscrn ; 
    } 
    }

    if(izoomin){
    radscrn = 2.0*radscrn;
    izoomin=false;
    }

    if(izoomout){
    radscrn = 0.5*radscrn;
    izoomout=false;
    }


// now draw the orbits 
 
    if(iorbits == true){ 
    int orb1width = (int) (0.5*radscrn*( 2.0*ast1) ); 
    int orb1height= (int) (0.5*radscrn* (2.0*ast1*Math.sqrt(1.0-epsilon*epsilon)) ); 
    int orb1x0 = (int)(0.5*screenscale + 0.5*radscrn*(-ast1*(1.0-epsilon))); 
    int orb1y0 = (int)(0.5*screenscale - 0.5*radscrn*(ast1*Math.sqrt(1.0-epsilon*epsilon))); 
    g.setColor(new Color(0,128,0)); 
    g.drawOval(orb1x0,orb1y0,orb1width,orb1height); 
 
    int orb2width = (int) (0.5*radscrn*( 2.0*ast2) ); 
    int orb2height= (int) (0.5*radscrn* (2.0*ast2*Math.sqrt(1.0-epsilon*epsilon)) ); 
    int orb2x0 = (int)(0.5*screenscale + 0.5*radscrn*(-ast2*(1.0+epsilon))); 
    int orb2y0 = (int)(0.5*screenscale - 0.5*radscrn*(ast2*Math.sqrt(1.0-epsilon*epsilon))); 
    g.drawOval(orb2x0,orb2y0,orb2width,orb2height); 
    } 
 
 
// period of orbit 
    pyrs=1.0; 
    if(!isim){ 
    pyrs= Math.sqrt( (1.0/(mass1+mass2)) * Math.pow(astars,3.0) ); 
    } 
    if(isim){ 
    pyrs = perioddata[doublenumber]; 
    } 
    dtime = 0.01*pyrs;
    if(epsilon >= 0.85){
    dtime = 0.002*pyrs;
    }
 
// star positions are 
    double rstar1 = ast1*(1.0-epsilon*epsilon)/(1.0-epsilon*Math.cos(theta)); 
    xstar[1][1] = Math.cos(theta)*rstar1; 
    xstar[1][2] = Math.sin(theta)*rstar1; 
    xstar[2][1] = -(mass1/mass2)*xstar[1][1]; 
    xstar[2][2] = -(mass1/mass2)*xstar[1][2]; 
 
// draw star A on the screen 
    g.setColor(Color.yellow); 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[1][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[1][2]); 
 
    int istarrad = (int) Math.max(2.0,4.0*radscrn/screenscale); 
    if(istarrad > 8) { istarrad=8; } 
    g.drawImage(img1data[doublenumber],ixdraw-istarrad,iydraw-istarrad,2*istarrad,2*istarrad,this); 
 
    if(ilabels == true){ 
    g.setColor(label1color[doublenumber]); 
    g.drawString (sstar1[doublenumber], ixdraw, iydraw); 
    } 
 
// draw star B 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[2][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[2][2]); 
 
    g.drawImage(img2data[doublenumber],ixdraw-istarrad,iydraw-istarrad,2*istarrad,2*istarrad,this); 
    if(ilabels == true){ 
    g.setColor(label2color[doublenumber]); 
    g.drawString (sstar2[doublenumber], ixdraw, iydraw); 
    } 
 
    if(istep == true){ 
    time  += dtime; 
    double dtheta=2.0*pi*(ast1/rstar1)*(ast1/rstar1)*Math.sqrt(1.0-epsilon*epsilon)*dtime/pyrs; 
    theta += dtheta; 
    } 
 
 //ereiamjh

    if(iroche){

    rstar2 = (mass1/mass2)*rstar1;
    r12sum = rstar1+rstar2;
    xtemp = r12sum/(1.0+Math.sqrt(mass2/mass1));
    vcontour = mass1/xtemp + mass2/(r12sum-xtemp);

    g.setColor(new Color(0,0,255));
    for (iy=0; iy<300; iy+=2){
    vdistprev=-1.0;
    for (ix=0; ix<300; ix+=2){
    xtry = (  ( (double) 2*ix) - screenscale )/radscrn  ;
    ytry = (  (-(double) 2*iy) + screenscale )/radscrn  ;
    x1try = xstar[1][1]-xtry;
    y1try = xstar[1][2]-ytry;
    x2try = xstar[2][1]-xtry;
    y2try = xstar[2][2]-ytry;
    r1try = Math.sqrt(x1try*x1try+y1try*y1try);
    r2try = Math.sqrt(x2try*x2try+y2try*y2try);
    vpot = mass1/r1try + mass2/r2try;
    vdist = vpot - vcontour;
    passcontour = vdist*vdistprev; 
    vdistprev = vdist;
    if( passcontour < 0.0){
    g.fillRect(ix-2,iy,2,1);
    }
    }
    }

    for (ix=0; ix<300; ix+=2){
    vdistprev=-1.0;
    for (iy=0; iy<300; iy+=2){
    xtry = (  ( (double) 2*ix) - screenscale )/radscrn  ;
    ytry = (  (-(double) 2*iy) + screenscale )/radscrn  ;
    x1try = xstar[1][1]-xtry;
    y1try = xstar[1][2]-ytry;
    x2try = xstar[2][1]-xtry;
    y2try = xstar[2][2]-ytry;
    r1try = Math.sqrt(x1try*x1try+y1try*y1try);
    r2try = Math.sqrt(x2try*x2try+y2try*y2try);
    vpot = mass1/r1try + mass2/r2try;
    vdist = vpot - vcontour;
    passcontour = vdist*vdistprev; 
    vdistprev = vdist;
    if( passcontour < 0.0) {
    g.fillOval(ix,iy-2,1,2);
    }
    }
    }


    }

// draw axes  
    if(igrid == true){ 
    g.setColor(std_blue); 
    g.drawArc(mrquart,mrquart,mrhalf,mrhalf,0,360); 
    g.drawArc(0,0,mrone,mrone,0,360); 
    g.setColor(std_blue); 
    g.drawLine(0,mrhalf,mrone,mrhalf); 
    g.drawLine(mrhalf,0,mrhalf,mrone); 
    g.drawLine(ix1, ticy1, ix1, ticy2); 
    g.drawLine(ix2, ticy1, ix2, ticy2); 
    g.drawLine(ix3, ticy1, ix3, ticy2); 
    g.drawLine(ix4, ticy1, ix4, ticy2); 
    g.drawLine(ix5, ticy1, ix5, ticy2); 
    g.drawLine(ticx1, iy1, ticx2, iy1); 
    g.drawLine(ticx1, iy2, ticx2, iy2); 
    g.drawLine(ticx1, iy3, ticx2, iy3); 
    g.drawLine(ticx1, iy4, ticx2, iy4); 
    g.drawLine(ticx1, iy5, ticx2, iy5); 
    g.setColor(std_blue); 
    double screenmagnif = ((double) screenscale) /( (double) radscrn ); 
    g.drawString(decimalPlace(4,(double) 0.5*screenmagnif)+" [AU]",3*mrquart+5,mrhalf-5); 
    g.drawString(decimalPlace(4,(double) screenmagnif)+" [AU]",mrone+5,mrhalf-5); 
    } 
// end axis drawing 
 
// data and info drawing 

    if(isim){ 
    g.setColor(std_yellow); 
    doublename = doublenamedata[doublenumber];
    g.drawString("Simulation of double "+doublename+aftertext[doublenumber],
    180,270);
    g.setColor(std_yellow); 
    double dpc = distpcdata[doublenumber];
    if(dpc >= 10.0){
    g.drawString("distance from Earth = "+decimalPlace(0,dpc)+ " [pc]", 180,285); 
    }
    if(dpc < 10.0){
    g.drawString("distance from Earth = "+decimalPlace(1,dpc)+ " [pc]", 180,285); 
    }
    } 

    g.setColor(std_gray4);
    g.fillRect(220,0,110,50);
    g.setColor(std_white);
    g.drawRect(220,0,110,50);
    g.setColor(std_gray1);
    if(pyrs >= 10.0){
    g.drawString("time = "+decimalPlace(0,time)+" [yrs]", 230, 20);
    }
    if(!(pyrs >= 10.0)){
    g.drawString("time = "+decimalPlace(1,time)+" [yrs]", 230, 20);
    }
    double r12 = (1.0+mass1/mass2)*rstar1; 
    g.drawString("r_12 = "+decimalPlace(1,r12)+" [AU]",   230, 40);  
 
// bc drawing 
    g.setColor(std_gray1); 
    g.drawString("Mass of star A",                430, 20); 
    g.drawString("Mass of star B",                430, 80); 
    g.drawString("Semimajor axis",                433,140); 
    g.drawString("Eccentricity",                  440,200); 
    g.drawString(decimalPlace(1,mass1)+" [Msun]", 440, 35); 
    g.drawString(decimalPlace(1,mass2)+" [Msun]", 440, 95); 
    g.drawString(decimalPlace(1,astars)+" [AU]",  445,155); 
    g.drawString(decimalPlace(2,epsilon),         455,215); 
    g.setColor(std_yellow);
    g.drawString("orbital period = "+decimalPlace(2,pyrs)+" [yrs]", 180,300); 
 
//end of paint() 
} 
 
// Dr.Guidry's patented truncatator 
 
public String decimalPlace(int nright, double number) { 
   double n = number; 
   String tright2 =""; 
   String total=String.valueOf(n); 
   int nperiod = total.indexOf("."); 
   if(nperiod == 0 || nperiod == -1) {return total;} 
   String tleft=total.substring(0,nperiod); 
   String tright=total.substring(nperiod); 
   int temp1=0, temp2=nright+1; 
   if(tright.length() > nright) { 
      try{tright2=tright.substring(temp1,temp2);} 
          catch(StringIndexOutOfBoundsException e) 
      { ; } 
   } 
   else { 
      tright2=tright; 
   } 
   return tleft+tright2; 
}  
 
 
/* 
 * called when the applet is started 
 * create a new instance of Thread and start it 
 */ 
public void start() { 
 
        if(thread == null) { 
                thread = new Thread(this); 
                thread.start(); 
        } 
} 
 
/* 
 * called when the applet is stopped 
 * stops the thread 
 */ 
public void stop() { 
 
	thread = null; 
} 
 
/* 
 * the thread itself 
 * sleeps for (arg) ms and forces a repaint 
 */ 
public void run() { 
 
	while (thread != null) { 
 
                try { 
                        Thread.sleep(50); 
                } catch (InterruptedException e) { } 
                  repaint();
 
	} 
	thread = null; 
} 
 
/** 
 * override the default update method to avoid 
 * flickering caused by unnecessary erasing of the applet panel 
 * @param g - destination graphics object 
 */ 
public void update(Graphics g) { 
         Graphics offScreenGraphics = offScreenImage.getGraphics();
         offScreenGraphics.setColor(getBackground());
         offScreenGraphics.fillRect(0,0,size().width,size().height);
         offScreenGraphics.setColor(g.getColor());
         paint(offScreenGraphics);
         g.drawImage(offScreenImage,0,0,this);
 } 
// 
/** 
 * application entry point 
 * not used when run as an applet 
 * create a new window frame and add the applet inside 
 * @param args[] - command line arguments 
 */ 
public static void main (String args[]) { 
 
        Frame f = new Frame ("Roche"); 
        Roche system = new Roche (); 
   
//        f.resize (210, 230); 
        f.resize (100, 100); 
        f.add ("Center", system); 
	f.show (); 
        system.init (); 
        system.start (); 
} 
} 
 
class HelpFrameR extends Frame
{
public int ipalette;
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
public String hstringtest;
public String textb[] = new String[31];

HelpFrameR(int ipalarg, String h0, String h1, String h2, String h3, String h4, String h5,
String h6, String h7, String h8, String h9, String h10, String h11,
String h12, String h13, String h14, String h15, String h16, String h17, String h18,
String h19, String h20, String h21, String h22, String h23, String h24)
  {
  ipalette=ipalarg;
  hstringtest   = h0;
  textb[1]      = h1;
  textb[2]      = h2;
  textb[3]      = h3;
  textb[4]      = h4;
  textb[5]      = h5;
  textb[6]      = h6;
  textb[7]      = h7;
  textb[8]      = h8;
  textb[9]      = h9;
  textb[10]     = h10;
  textb[11]     = h11;
  textb[12]     = h12;
  textb[13]     = h13;
  textb[14]     = h14;
  textb[15]     = h15;
  textb[16]     = h16;
  textb[17]     = h17;
  textb[18]     = h18;
  textb[19]     = h19;
  textb[20]     = h20;
  textb[21]     = h21;
  textb[22]     = h22;
  textb[23]     = h23;
  textb[24]     = h24;
  }
  public void paint(Graphics g)
     {
// set up a 520x520 size data frame
     int fw = 520;
     int fh = 540;
//     resize(fw,fh);
// tried "Dialog" and it was too large
     Font framefont = new Font("Arial", Font.PLAIN, 10);
     g.setFont(framefont);
     if(ipalette==1){g.setColor(std_gray4); }
     if(ipalette==2){g.setColor(new Color(51,51,51)); }
     if(ipalette==3){g.setColor(Color.black); }
     g.fillRect(0,0,fw,fh);
     g.setColor(Color.green);
     g.drawString(hstringtest,30,50);
     if(ipalette==1){g.setColor(Color.cyan); }
     if(ipalette==2){g.setColor(std_yellow); }
     if(ipalette==3){g.setColor(Color.blue); }
     int ihwrite = 80;
     g.drawString("FUNCTIONS:",30,ihwrite);
     ihwrite+=15;
     int itextloop;
     for(itextloop=1; itextloop<17; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }
     ihwrite+=15;
     g.setColor(std_yellow);
     for(itextloop=17; itextloop<31; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }

     }

  public boolean handleEvent(Event evt)
     {
     switch(evt.id)
     {
        case Event.WINDOW_DESTROY:
        dispose();
        return true;
     }
     return false;
     }

}

// thats all folks

