// Orbit.java 
// 1 planet orbiting a double star  
// this is a debug version that shows two R-K updates 
// with step sizes that differ by a factor of 2 
// there is an adaptive step size based on the star's min distance 
// for the RK integration 
 
// 
//  class  method       qualifiers 
// 
//  Orbit              p A R 
//         init         p v 
//         paint        p v 
//         start        p v 
//         stop         p v 
//         run          p v 
//         update       p v     may be commented out 
//         main         p s v   not used as applet 
 
 
import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.util.Date; 
 
 
public class Orbit extends Applet implements Runnable { 
 
Panel panelH = new Panel(); 
Panel panelV = new Panel();
Panel panelv1= new Panel(); 
Button button0v,button1v,button2v,button3v,button4v,button5v,button6v,button7v,button8v,button9v,button10v,button1h,button2h; 
Scrollbar sth0,sa0,sx0,sv0; 
HelpFrameO helpframe;
 
// the instance of Thread for checking the time periodically 
Thread thread = null; 
 
// planet and star setup data 
// funny numbers are because it uses first index = 0 
// but i use 1,2,...,n_objects 
public static double vconvert=29.7653; 
public double vy0kmps; 
public double thstars; 
public double astars; 
public int nstars  =3; 
public int nplanets=2; 
public int ncoords =4; 
public int nmethods=4; 
public Label labelth0 = new Label("",Label.CENTER);
public Label labela0 = new Label("",Label.CENTER);
public Label labelx0 = new Label("",Label.CENTER);
public Label labelv0 = new Label("",Label.CENTER);
public Label labelth0text=new Label("Initial theta",Label.CENTER);
public Label labela0text=new Label("Initial a(stars)",Label.CENTER);
public Label labelx0text=new Label("Initial x(planet)",Label.CENTER);
public Label labelv0text=new Label("Initial v_y(planet)",Label.CENTER);
public double xstar[][] = new double[nstars][ncoords]; 
public double vstar[][] = new double[nstars][ncoords]; 
public double xplanet[][][] = new double[nplanets][ncoords][nmethods]; 
public double vplanet[][][] = new double[nplanets][ncoords][nmethods]; 
public double xvec_ps[][][] = new double[nstars][ncoords][nmethods]; 
public double xps[][]     = new double[nstars][nmethods]; 
public double yps[][]     = new double[nstars][nmethods]; 
public double rps[][]     = new double[nstars][nmethods]; 
public double rpssq[][]   = new double[nstars][nmethods]; 
public double rpscube[][] = new double[nstars][nmethods]; 
public double k_1[][] = new double[ncoords][nmethods]; 
public double k_2[][] = new double[ncoords][nmethods]; 
public double k_3[][] = new double[ncoords][nmethods]; 
public double k_4[][] = new double[ncoords][nmethods]; 
public double l_1[][] = new double[ncoords][nmethods]; 
public double l_2[][] = new double[ncoords][nmethods]; 
public double l_3[][] = new double[ncoords][nmethods]; 
public double l_4[][] = new double[ncoords][nmethods]; 
public double xerr=0.0; 
public double yerr=0.0; 
public double xerrnumrecip=0.0; 
public double yerrnumrecip=0.0;  
 
// screen setup 
public int ipalette=1;
public Color ai_textcolor = new Color(144,196,196);
Image imgstar[] = new Image[nstars];
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
public double screenscale; 
private Image offScreenImage;
public double radscrn;
public double rdisplaymax=1.1; 
public double rdisplaymin=0.4; 
public static double pi=3.14159265358979323; 
 
// array declarations that actually work: 
//int numvals=30; 
//double numbers[][] = new double[numvals][numvals]; 
//float numbers[] = new float[30]; 
 
public double dtime0=0.01; 
public int iresol=0; 
public double dtime = dtime0 * Math.pow(2.0,(double) iresol); 
public double time = 0.0; 
public double xreal,yreal,vx,vy; 
 
// for axis and data drawing 
// istep=false allows screen clear or adjust w/o stepping time 
public boolean istep   = false; 
public boolean ierrbox = true; 
public boolean ishowbc = true; 
public boolean idata   = true; 
public boolean igrid   = true; 
public boolean ilabels = true; 
public int ix1,ix2,ix3,ix4,ix5,iy1,iy2,iy3,iy4,iy5; 
public int ticx1,ticx2,ticy1,ticy2,mrone,mrhalf,mrquart; 
// repaint planet region 
public int ixrepp,iyrepp,ixreps1,iyreps1,ixreps2,iyreps2; 
//// sounds 
//AudioClip beep[] = new AudioClip[10]; 
 
public void init(){ 

    offScreenImage = createImage(size().width,size().height);
    imgstar[1] = getImage(getDocumentBase(),"sun_yellow.jpg"); 
    imgstar[2] = getImage(getDocumentBase(),"sun_yellow.jpg"); 
// needed for axis drawing 
    Dimension d = size(); 
    screenscale= 0.9 * (double) d.height; 
    radscrn=screenscale; 
    mrone = (int) screenscale; 
    mrhalf= (int) (0.5*screenscale); 
    mrquart=(int) (0.25*screenscale);  
    ticy1= (int) (0.48*screenscale); 
    ticy2= (int) (0.52*screenscale); 
    ix1=0; 
    ix2= mrquart; 
    ix3= mrhalf; 
    ix4= 3*mrquart; 
    ix5= mrone; 
    ticx1= ticy1; 
    ticx2= ticy2; 
    iy1=0; 
    iy2= mrquart; 
    iy3= mrhalf; 
    iy4= 3*mrquart; 
    iy5= mrone; 
 
this.setBackground(Color.black); 
this.setLayout(null); 


panelV.setLayout(null);
panelV.setBounds (0,320,520,20); 
add(panelV); 
 
 
// defines buttons 
    button0v = new Button("About");
    button1v = new Button("Start");
//    button2v = new Button("Stop");
    button3v = new Button("Reset");
    button4v = new Button("Grid");
    button5v = new Button("Data");
    button6v = new Button("Labels");
    button7v = new Button("Finer");
    button8v = new Button("Coarser");
//    button9v = new Button("ErrBox");
//    button10v = new Button("Params");
//    button1h = new Button("enough!");
// sets button bounds
    int ibuttonspace=65;
    button1v.setBounds(0,     0, 55,20);
    button3v.setBounds (  ibuttonspace,   0, 55,20);
    button4v.setBounds (2*ibuttonspace,   0, 55,20);
    button6v.setBounds (3*ibuttonspace,   0, 55,20);
    button5v.setBounds (4*ibuttonspace,   0, 55,20);
    button7v.setBounds (5*ibuttonspace,   0, 55,20);
    button8v.setBounds (6*ibuttonspace,   0, 55,20);
    button0v.setBounds (7*ibuttonspace,   0, 55,20);
//adds buttons
    panelV.add(button1v); 
    panelV.add(button3v); 
    panelV.add(button4v); 
    panelV.add(button6v); 
    panelV.add(button5v); 
//    panelV.add(button10v); 
    panelV.add(button7v); 
    panelV.add(button8v); 
    panelV.add(button0v);

    if(ipalette==1){
    button0v.setBackground(std_gray2);
    button1v.setBackground(std_gray2);
//    button2v.setBackground(std_gray2);
    button3v.setBackground(std_gray2);
    button4v.setBackground(std_gray2);
    button5v.setBackground(std_gray2);
    button6v.setBackground(std_gray2);
    button7v.setBackground(std_gray2);
    button8v.setBackground(std_gray2);
//    button9v.setBackground(std_gray2);
//    button10v.setBackground(std_gray2);
    }

    if(ipalette==3){
    button1v.setBackground(new Color(100,200,100));
//    button2v.setBackground(new Color(200,100,100));
    button3v.setBackground(new Color(200,100,100));
    button4v.setBackground(new Color(100,100,255));
    button5v.setBackground(new Color(100,100,255));
    button6v.setBackground(new Color(100,100,255));
    button7v.setBackground(new Color(100,100,255));
    button8v.setBackground(new Color(100,100,255));
//    button9v.setBackground(new Color(100,100,255));
//    button10v.setBackground(new Color(100,100,255));
    button0v.setBackground(new Color(200,000,200));
    }

// new panel test
      panelv1.setLayout(null);
      panelv1.setBounds(420,0,100,320);
      add(panelv1);
// defines scrollbar 
      sth0 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,0,181); 
      sa0 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,1,101); 
      sx0 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,0,101); 
      sv0 = new Scrollbar (Scrollbar.HORIZONTAL,0,1,-1001,1001); 
      sth0.setValue(0); 
      sa0.setValue(40); 
      sx0.setValue(50); 
      sv0.setValue(+320); 
      thstars =   (double) (sth0.getValue()); 
      astars=0.01*(double) (sa0.getValue()); 
      xreal=0.02*(double) (sx0.getValue());  
      vy0kmps = 0.1*sv0.getValue(); 
         labelth0.setText(String.valueOf(decimalPlace(0,thstars))+" [deg]");
         labela0.setText(String.valueOf(decimalPlace(2,astars))+" [AU]");
         labelx0.setText(String.valueOf(decimalPlace(2,xreal))+" [AU]");
         labelv0.setText(String.valueOf(decimalPlace(1,vy0kmps))+" [km/sec]");
      sth0.setBounds(0, 60,100,15);
      sth0.setBackground(std_gray2);
      panelv1.add(sth0);
      sa0.setBounds(0,120,100,15);
      sa0.setBackground(std_gray2);
      panelv1.add(sa0);
      sx0.setBounds(0,180,100,15);
      sx0.setBackground(std_gray2);
      panelv1.add(sx0);
      sv0.setBounds(0,240,100,15);
      sv0.setBackground(std_gray2);
      panelv1.add(sv0);


      labelth0text.setBounds(0,25,100,15);
      labelth0text.setForeground(std_gray1);
      labelth0text.setBackground(Color.black);
      panelv1.add(labelth0text);
      labelth0.setBounds(0,40,100,15);
      labelth0.setForeground(std_gray1);
      labelth0.setBackground(Color.black);
      panelv1.add(labelth0);

      labela0text.setBounds(0,85,100,15);
      labela0text.setForeground(std_gray1);
      labela0text.setBackground(Color.black);
      panelv1.add(labela0text);
      labela0.setBounds(0,100,100,15);
      labela0.setForeground(std_gray1);
      labela0.setBackground(Color.black);
      panelv1.add(labela0);


      labelx0text.setBounds(0,145,100,15);
      labelx0text.setForeground(std_gray1);
      labelx0text.setBackground(Color.black);
      panelv1.add(labelx0text);
      labelx0.setBounds(0,160,100,15);
      labelx0.setForeground(std_gray1);
      labelx0.setBackground(Color.black);
      panelv1.add(labelx0);

      labelv0text.setBounds(0,205,100,15);
      labelv0text.setForeground(std_gray1);
      labelv0text.setBackground(Color.black);
      panelv1.add(labelv0text);
      labelv0.setBounds(0,220,100,15);
      labelv0.setForeground(std_gray1);
      labelv0.setBackground(Color.black);
      panelv1.add(labelv0);
       
// setup start coords and veloc 
    time=0.0; 
    thstars =   (double) (sth0.getValue()); 
    astars=0.01*(double) (sa0.getValue()); 
    xreal=0.02*(double) (sx0.getValue()); 
    vx=0.0; 
    vy0kmps = 0.1*sv0.getValue(); 
    vy = vy0kmps/vconvert; 
    yreal=0.0; 
 
    for(int imethod=1; imethod<nmethods; ++imethod){ 
    vplanet[1][1][imethod] = 0.0; 
    vplanet[1][2][imethod] = (1.0/vconvert)*vy0kmps; 
    xplanet[1][1][imethod] = 0.02*(double) (sx0.getValue()); 
    xplanet[1][2][imethod] = 0.0; 
    } 
 
//  get sounds 
//    String name1,name2; 
//    name1 = "drip.au"; 
//    showStatus("Getting "+name1); 
//    beep[1] = getAudioClip(getCodeBase(),name1); 
//    beep[1].play(); 
//    name2 = "spacemusic.au"; 
//    showStatus("Getting "+name2); 
//    beep[2] = getAudioClip(getCodeBase(),name2); 
//    beep[2].play(); 

} 
 
// scrollbars 
 
public boolean handleEvent(Event evt){ 
   if(evt.target instanceof Scrollbar) 
   { 
      button1v.setLabel("Start");
      thread = null; 
//// switch on bc viewer 
        ishowbc=true; 
// start at time=0.0 
         time=0.0; 
         thstars =   (double) (sth0.getValue()); 
         astars=0.01*(double) (sa0.getValue()); 
         xreal=0.02*(double) (sx0.getValue()); 
         vx=0.0; 
         vy0kmps = 0.1*sv0.getValue(); 
         vy = (1.0/vconvert)*vy0kmps; 
         yreal=0.0; 
         labelth0.setText(String.valueOf(decimalPlace(0,thstars))+" [deg]");
         labela0.setText(String.valueOf(decimalPlace(2,astars))+" [AU]");
         labelx0.setText(String.valueOf(decimalPlace(2,xreal))+" [AU]");
         labelv0.setText(String.valueOf(decimalPlace(1,vy0kmps))+" [km/sec]");

    for(int imethod=1; imethod<nmethods; ++imethod){
    vplanet[1][1][imethod] = 0.0; 
    vplanet[1][2][imethod] = (1.0/vconvert)*vy0kmps; 
    xplanet[1][1][imethod] = 0.02*(double) (sx0.getValue()); 
    xplanet[1][2][imethod] = 0.0; 
    } 
 
       istep  = false; 
       repaint(); 
       return true; 
   } 
   else 
   { 
      boolean result = super.handleEvent(evt); 
      return result; 
   } 
} 
  
public boolean action(Event evt, Object arg){ 
 
  if((evt.target instanceof Button)&&(arg == "About")) {
//    beep[1].play(); 
        helpframe = new HelpFrameO(
"This is a Java simulation of a planet orbiting a double star.", 
"The basic functions of the applet are as follows:",
"'Start/Stop' begins and pauses the simulation.",
"'Reset' return the simulation to time=0.",
"'Grid' shows a calibrated length scale in [AU], centered on the stars' c.o.g.",
"'Labels' identifies the stars and the planet.",
"'Data' shows the elapsed time in [yrs], the planet's distance from the stars' c.o.g. in [AU],",
"     and the planet's velocity in [km/sec] and estimated temp assuming the Earth's albedo.",
"'Finer' halves the time step size dtime, making the predicted positions approx 16x more accurate.",
"'Coarser' doubles the time step dtime, which gives a faster but less accurate simulation.",
"An error box shows estimated position errors as two faint gray rectangles.",
"     If these become visible, 'Reset' and decrease dtime using 'Finer'.",
"The parameters can be changed by using the sliders followed by 'Start'.",
" ",
"THE SIMULATION:",
"The stars are placed in a circular orbit with the specified orbit parameters.",
"Each star is taken to have 1/2 solar mass and luminosity.",
"F=ma is then integrated numerically for the planet with the specified initial conditions,",
"using two successive Runge-Kutta integrations. These are extrapolated as recommended in",
"Numerical Recipies, and the extrapolated position is shown as a plus sign.",
"The Num. Rec. estimated position error is shown as the smaller gray box.",
"and the difference between the two unextrapolated Runge-Kutta simulations is the larger gray box.",
"                                                                       Java programming by Ted Barnes",
""
);

        helpframe.resize(520,500);
        helpframe.move(0,0);
        helpframe.show();
         istep = false;
         repaint();
         istep=true; 
      }

   if((evt.target instanceof Button)&&(arg == "Start")) {
//         beep[1].play();
         thread = new Thread(this);
         if(ipalette == 3){
         button1v.setBackground(new Color(0,255,0));
//         button2v.setBackground(new Color(200,100,100));
         button3v.setBackground(new Color(200,100,100));
         panelV.add(button1v);
//         panelV.add(button2v);
         panelV.add(button3v);
         }
//
         thread.start();
         istep = false;
         button1v.setLabel("Stop");
         repaint();
         istep=true;
   }
 
//   if((evt.target instanceof Button)&&(arg == "enough!")) {
//   beep[2].stop();
//   button1h.setLabel("music");
//   }
//   if((evt.target instanceof Button)&&(arg == "music")) {
//   beep[2].loop();
//   button1h.setLabel("enough!");
//   }

   if(evt.target instanceof Button){ 
        if(arg == "Reset") {
         button1v.setLabel("Start"); 
         if(ipalette==3){       
         button1v.setBackground(new Color(100,200,100));
//         button2v.setBackground(new Color(200,100,100));
         button3v.setBackground(new Color(200,100,100));
         }
         panelV.add(button1v);
//         panelV.add(button2v);
         panelV.add(button3v);
        thread = null; 
        istep=false; 
        repaint(); 
         time=0.0; 
         dtime=dtime0; 
         iresol=0; 
         thstars =   (double) (sth0.getValue()); 
         astars=0.01*(double) (sa0.getValue()); 
         xreal=0.02*(double) (sx0.getValue()); 
         vx=0.0; 
         vy0kmps = 0.1*sv0.getValue(); 
         vy = (1.0/vconvert)*vy0kmps; 
         yreal=0.0; 
    for(int imethod=1; imethod<nmethods; ++imethod){ 
    vplanet[1][1][imethod] = 0.0; 
    vplanet[1][2][imethod] = (1.0/vconvert)*vy0kmps; 
    xplanet[1][1][imethod] = 0.02*(double) (sx0.getValue()); 
    xplanet[1][2][imethod] = 0.0; 
    }
        }
   }

   if(evt.target instanceof Button){
        if((arg == "Start") && (thread == null)) {
         if(ipalette==3){
         button1v.setBackground(new Color(0,255,0));
//         button2v.setBackground(new Color(200,100,100));
         button3v.setBackground(new Color(200,100,100));
         }
         button1v.setLabel("Stop");
         panelV.add(button1v);
//         panelV.add(button2v);
         panelV.add(button3v);

                thread = new Thread(this);
                thread.start();
        }
   }
   if(arg == "Stop"){
         if(ipalette==3){
         button1v.setBackground(new Color(100,200,100));
//         button2v.setBackground(new Color(255,0,0));
         }
         button1v.setLabel("Start");
         panelV.add(button1v);
//         panelV.add(button2v);         
         istep=false; 
         repaint(); 
         thread = null; 
         istep=false; 
   } 
   if(arg == "Grid"){ 
         igrid = !igrid; 
        if(ipalette==3){
        if(igrid  == false){
        button4v.setBackground(Color.gray);
        button4v.setForeground(Color.darkGray);
        }
        if(igrid == true)
        {
        button4v.setBackground(new Color(100,100,255));
        button4v.setForeground(Color.black);
        }
        panelV.add(button4v);
        }
         istep=false; 
         repaint(); 
         if(thread != null) {istep=true;} 
   } 
   if(arg == "Data"){ 
         idata = !idata; 
       if(ipalette==3){ 
       if(idata == false){
        button5v.setBackground(Color.gray);
        button5v.setForeground(Color.darkGray);
        }
        if(idata == true)
        {
        button5v.setBackground(new Color(100,100,255));
        button5v.setForeground(Color.black);
        }
        panelV.add(button5v);
        }
         istep=false; 
         repaint(); 
         if(thread != null) {istep=true;} 
   } 
   if(arg == "Labels"){ 
         ilabels = !ilabels; 
        if(ipalette==3){
        if(ilabels == false){
        button6v.setBackground(Color.gray);
        button6v.setForeground(Color.darkGray);
        }
        if(ilabels == true)
        {
        button6v.setBackground(new Color(100,100,255));
        button6v.setForeground(Color.black);
        }
        panelV.add(button6v);
        }
         istep=false; 
         repaint(); 
         if(thread != null) {istep=true;} 
   } 
   if(arg == "Finer"){ 
         ishowbc=true; 
         iresol = iresol-1; 
         dtime = dtime0 * Math.pow(2.0,(double) iresol); 
         istep=false; 
         repaint(); 
         if(thread != null) {istep=true;} 
   } 
   if(arg == "Coarser"){ 
         ishowbc=true; 
         iresol=iresol+1; 
         dtime = dtime0 * Math.pow(2.0,(double) iresol); 
         istep=false; 
         repaint(); 
         if(thread != null) {istep=true;} 
   } 

//   if(arg == "ErrBox"){
//        ierrbox = !ierrbox;
//        if(ierrbox == false){
//        button9v.setBackground(Color.gray);
//        button9v.setForeground(Color.darkGray);
//        }
//        if(ierrbox == true)
//        {
//        button9v.setBackground(new Color(100,100,255));
//        button9v.setForeground(Color.black);
//        }
//        panelV.add(button9v);
//   }


//   if(arg == "Params"){
//         ishowbc = !ishowbc;
//        if(ipalette==3){
//        if(ishowbc == false){
//        button10v.setBackground(Color.gray);
//        button10v.setForeground(Color.darkGray);
//        }
//        if(ishowbc == true)
//        {
//        button10v.setBackground(new Color(100,100,255));
//        button10v.setForeground(Color.black);
//        }
//        panelV.add(button10v);
//        }
//         istep=false;
//         repaint();
//         if(thread != null) {istep=true;}
//   }

   return true;
}


// my new stuff  
// draws the planet's motion 
 
public void paint (Graphics g) { 
// 
Font font = new Font("Arial", Font.PLAIN, 11);
g.setFont(font);

double rsq,rreal,rcube,dvx,dvy,dxreal,dyreal; 
double tyears,tempf,tempc,tempk,veloc; 
int ixdraw,iydraw; 
String text2; 
String text[]  = new String[20]; 
String sstar[] = new String[nstars]; 
sstar[1] = "  Star A"; 
sstar[2] = "  Star B"; 
text[2]  = "  die Welt"; 
text[7]  = "T(estm) =            [K]"; 
text[8]  = " [C]"; 
text[9]  = " [F]"; 
text[10] = "Set initial a(stars) "; 
text[11] = "[AU]"; 
text[12] = "Set initial x(planet) "; 
text[13] = "[AU]"; 
text[14] = "  Set initial v_y "; 
text[15] = "   [km/sec]"; 
text[16] = "  Runge-Kutta"; 
text[17] = "  Runge-Kutta higher resol."; 
text[18] = "   planet"; 
 
// 
// first we draw sky then update positions 
// 
 
 
// work out some x- and v-dependent numbers for data print on screen 
// and to set display size variable "radscrn" 
 
    tyears= time/(2.0*pi); 
    veloc=0.0; 
    rreal=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        veloc += vplanet[1][icoord][3]*vplanet[1][icoord][3]; 
        rreal += xplanet[1][icoord][3]*xplanet[1][icoord][3]; 
        } 
        veloc = Math.sqrt(veloc); 
        rreal = Math.sqrt(rreal); 
 
//  zoom image to a good planet scale 
 
    if(rreal > rdisplaymax && rdisplaymax < 50.) { 
    radscrn = 0.5*radscrn; 
    repaint(); 
    rdisplaymax=2.*rdisplaymax; 
    rdisplaymin=2.*rdisplaymin; 
    } 
    if(rreal < rdisplaymin && rdisplaymin > 0.5) { 
    radscrn = 2.0*radscrn; 
    repaint(); 
    rdisplaymax=0.5*rdisplaymax; 
    rdisplaymin=0.5*rdisplaymin; 
    }     
 
// star positions are 
    thstars = sth0.getValue(); 
    double pstars= astars*Math.sqrt(astars); 
    xstar[1][1] = astars*Math.cos(time/pstars + pi*(thstars/180.)); 
    xstar[1][2] = astars*Math.sin(time/pstars + pi*(thstars/180.)); 
    xstar[2][1] = -xstar[1][1]; 
    xstar[2][2] = -xstar[1][2]; 
 
// draw star 1 on the screen 
    g.setColor(Color.yellow); 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[1][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[1][2]); 
    int istarrad = Math.max(2, (int)(Math.round(Math.sqrt(30.*radscrn/screenscale))) ); 
 
    g.drawImage(imgstar[1],ixdraw-istarrad,iydraw-istarrad,2*istarrad,2*istarrad,this); 
    if(ilabels == true){ 
    g.drawString (sstar[1], ixdraw, iydraw); 
    } 
// for repainting 
    ixreps1=ixdraw; 
    iyreps1=iydraw; 
 
// draw star 2 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xstar[2][1]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xstar[2][2]); 
 
    g.drawImage(imgstar[2],ixdraw-istarrad,iydraw-istarrad,2*istarrad,2*istarrad,this); 
    if(ilabels == true){ 
    g.drawString (sstar[2], ixdraw, iydraw); 
    } 
    ixreps2=ixdraw; 
    iyreps2=iydraw; 
 
// update funcs of planet and star relative positions 
    for(int imethod=1; imethod<nmethods; ++imethod){ 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][imethod] = xplanet[1][icoord][imethod] - xstar[istar][icoord]; 
        } 
    } 
    } 
    for(int imethod=1; imethod<nmethods; ++imethod){ 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][imethod]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][imethod] += xvec_ps[istar][icoord][imethod]*xvec_ps[istar][icoord][imethod]; 
        } 
    rps[istar][imethod] =  Math.sqrt(rpssq[istar][imethod]); 
    rpscube[istar][imethod] =  rps[istar][imethod]*rpssq[istar][imethod]; 
    } 
    } 
 
// adaptive time steps; careful calc when close to stars 
     double minrsp1 = Math.min(rps[1][1],rps[2][1]); 
     double minrsp2 = Math.min(rps[1][2],rps[2][2]); 
     double minrsp  = Math.min(minrsp1,minrsp2); 
     if(minrsp > 0.1) {  
     dtime=dtime0*Math.pow(2.0,(double) iresol);  
     } 
     if(minrsp < 0.1) { dtime=0.001; } 
 
// planet temp for stars of 1/2 solar luminosity each 
 
    tempk=293.16*0.5d*(Math.sqrt(1.0/rps[1][3]) + Math.sqrt(1.0/rps[2][3]) ); 
    tempc=tempk-273.16; 
    tempf=1.8*tempk-459.69; 


// draw error box for planet's position 
    ixdraw = (int) (0.5*screenscale + 0.5*radscrn*xplanet[1][1][3]); 
    iydraw = (int) (0.5*screenscale - 0.5*radscrn*xplanet[1][2][3]); 
    if(ierrbox == true){ 
    g.setColor(std_gray2); 
    int ixsidehalf =  (int) (0.25*radscrn*xerr);     
    int iysidehalf =  (int) (0.25*radscrn*yerr); 
    g.drawRect(ixdraw-ixsidehalf,iydraw-iysidehalf,2*ixsidehalf,2*iysidehalf); 
    g.setColor(std_gray2); 
    ixsidehalf =  (int) (0.25*radscrn*xerrnumrecip);     
    iysidehalf =  (int) (0.25*radscrn*yerrnumrecip); 
    g.drawRect(ixdraw-ixsidehalf,iydraw-iysidehalf,2*ixsidehalf,2*iysidehalf); 
    } 

    int ired=0; 
    int igreen=0; 
    int iblue=0; 
    if(tempc > 100.) { 
    ired=255; 
    igreen=0; 
    iblue=0; 
    } 
    if(tempc < 100. && tempc > 0.) { 
    ired = (int) (255.*tempc/100.);  
    igreen=255; 
    iblue=0; 
    } 
    if(tempc < 0.) { 
    ired=0; 
    igreen = (int) (255.*tempk/273.16); 
    iblue=255; 
    } 
 
// draw planet with Temp color
    g.setColor(new Color(ired,igreen,iblue)); 
    g.drawLine(ixdraw, iydraw-2, ixdraw, iydraw+2); 
    g.drawLine(ixdraw-2, iydraw, ixdraw+2, iydraw); 
// for repainting 
    ixrepp=ixdraw; 
    iyrepp=iydraw; 
 
    if(ilabels == true){ 
    g.drawString (text[18], ixdraw, iydraw); 
    } 
  
// screen print of data 
 
    if(idata == true){ 
    g.setColor(std_gray4); 
    g.fillRect(305,5,105,95);
    g.setColor(std_gray2); 
    g.drawRect(305,5,105,95);
    g.setColor(std_gray1); 
    g.drawString("time =     "+decimalPlace(2,tyears)+" [yrs]",   310,20); 
    g.drawString("d_cog =  "+decimalPlace(2,rreal)+" [AU]",       310,35); 
    double vkmpsec=vconvert*veloc; 
    g.drawString("v =        "+decimalPlace(1,vkmpsec)+" [km/s]", 310,50);  
    g.setColor(new Color(ired,igreen,iblue)); 
    g.drawString(text[7],                     310,65); 
    g.drawString(String.valueOf((int) tempk), 370,65); 
//    g.drawString(text[8],310,80); 
    g.drawString(String.valueOf((int) tempc)+text[8], 370,80); 
//    g.drawString(text[9],310,95); 
    g.drawString(String.valueOf((int) tempf)+text[9], 370,95); 
    }

// 
    if(ishowbc == true){ 
    g.setColor(std_gray2); 
    g.drawString("dtime=" + decimalPlace(2,dtime0) + "*2^"
    +String.valueOf(iresol-1)+ "/pi [yrs]"  ,                   300,300);
    } 
 
// 
// 
// NOW calc new planet position 
// 1st method is conventional RK, 
// 2nd method is two RK 0.5*dtimeref steps 
 
// begin [1] method, conventional RK 
 
    xstar[1][1] = astars*Math.cos(time/pstars + pi*(thstars/180.)); 
    xstar[1][2] = astars*Math.sin(time/pstars + pi*(thstars/180.)); 
    xstar[2][1] = -xstar[1][1]; 
    xstar[2][2] = -xstar[1][2]; 
 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][1] = xplanet[1][icoord][1] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][1]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][1] += xvec_ps[istar][icoord][1]*xvec_ps[istar][icoord][1]; 
        } 
    rps[istar][1] =  Math.sqrt(rpssq[istar][1]); 
    rpscube[istar][1] =  rps[istar][1]*rpssq[istar][1]; 
    } 
 
// move if 
if(istep == true){ 
 
// Runge Kutta stuff 
 
// calc l1 and k1 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_1[icoord][1] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_1[icoord][1] += -0.5*dtime*xvec_ps[istar][icoord][1]/rpscube[istar][1]; 
//       k_1[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_1[icoord][1] = vplanet[1][icoord][1]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][1] += 0.5*l_1[icoord][1]; 
       vplanet[1][icoord][1] += 0.5*k_1[icoord][1]; 
    } 
// update xp funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][1] = xplanet[1][icoord][1] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][1]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][1] += xvec_ps[istar][icoord][1]*xvec_ps[istar][icoord][1]; 
        } 
    rps[istar][1] =  Math.sqrt(rpssq[istar][1]); 
    rpscube[istar][1] =  rps[istar][1]*rpssq[istar][1]; 
    } 
// calc l2 and k2 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_2[icoord][1] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_2[icoord][1] += -0.5*dtime*xvec_ps[istar][icoord][1]/rpscube[istar][1]; 
//       k_2[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_2[icoord][1] = vplanet[1][icoord][1]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][1] += 0.5*(l_2[icoord][1]-l_1[icoord][1]); 
       vplanet[1][icoord][1] += 0.5*(k_2[icoord][1]-k_1[icoord][1]); 
    } 
// update xp funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][1] = xplanet[1][icoord][1] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][1]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][1] += xvec_ps[istar][icoord][1]*xvec_ps[istar][icoord][1]; 
        } 
    rps[istar][1] =  Math.sqrt(rpssq[istar][1]); 
    rpscube[istar][1] =  rps[istar][1]*rpssq[istar][1]; 
    } 
// calc l3 and k3 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_3[icoord][1] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_3[icoord][1] += -0.5*dtime*xvec_ps[istar][icoord][1]/rpscube[istar][1]; 
//       k_3[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_3[icoord][1] = vplanet[1][icoord][1]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][1] += l_3[icoord][1]-0.5*l_2[icoord][1]; 
       vplanet[1][icoord][1] += k_3[icoord][1]-0.5*k_2[icoord][1]; 
    } 
// update funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][1] = xplanet[1][icoord][1] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][1]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][1] += xvec_ps[istar][icoord][1]*xvec_ps[istar][icoord][1]; 
        } 
    rps[istar][1] =  Math.sqrt(rpssq[istar][1]); 
    rpscube[istar][1] =  rps[istar][1]*rpssq[istar][1]; 
    } 
// calc l4 and k4 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_4[icoord][1] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_4[icoord][1] += -0.5*dtime*xvec_ps[istar][icoord][1]/rpscube[istar][1]; 
//       k_4[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_4[icoord][1] = vplanet[1][icoord][1]*dtime; 
    } 
// reset x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][1] += -l_3[icoord][1]; 
       vplanet[1][icoord][1] += -k_3[icoord][1]; 
    } 
 
// Runge-Kutta (4th order) updates 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       vplanet[1][icoord][1] += (k_1[icoord][1]+2.0*k_2[icoord][1]+2.0*k_3[icoord][1]+k_4[icoord][1])/6.0; 
       xplanet[1][icoord][1] += (l_1[icoord][1]+2.0*l_2[icoord][1]+2.0*l_3[icoord][1]+l_4[icoord][1])/6.0; 
    } 
} 
 
// above } is the end of the if-istep bracket 
// end method [1] RK update 
 
// begin method [2] = two half-steps of RK 
// first make sure it works with full steps! 
// 
    dtime = 0.5*dtime; 
    for(int ihalfstep=1; ihalfstep<3; ++ihalfstep){    
 
    xstar[1][1] = astars*Math.cos(time/pstars + pi*(thstars/180.)); 
    xstar[1][2] = astars*Math.sin(time/pstars + pi*(thstars/180.)); 
    xstar[2][1] = -xstar[1][1]; 
    xstar[2][2] = -xstar[1][2]; 
 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][2] = xplanet[1][icoord][2] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][2]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][2] += xvec_ps[istar][icoord][2]*xvec_ps[istar][icoord][2]; 
        } 
    rps[istar][2] =  Math.sqrt(rpssq[istar][2]); 
    rpscube[istar][2] =  rps[istar][2]*rpssq[istar][2]; 
    } 
 
// move if 
if(istep == true){ 
 
// Runge Kutta stuff 
 
//  calc l1 and k1 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_1[icoord][2] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_1[icoord][2] += -0.5*dtime*xvec_ps[istar][icoord][2]/rpscube[istar][2]; 
//       k_1[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_1[icoord][2] = vplanet[1][icoord][2]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][2] += 0.5*l_1[icoord][2]; 
       vplanet[1][icoord][2] += 0.5*k_1[icoord][2]; 
    } 
// update xp funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][2] = xplanet[1][icoord][2] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][2]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][2] += xvec_ps[istar][icoord][2]*xvec_ps[istar][icoord][2]; 
        } 
    rps[istar][2] =  Math.sqrt(rpssq[istar][2]); 
    rpscube[istar][2] =  rps[istar][2]*rpssq[istar][2]; 
    } 
// calc l2 and k2 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_2[icoord][2] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_2[icoord][2] += -0.5*dtime*xvec_ps[istar][icoord][2]/rpscube[istar][2]; 
//       k_2[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_2[icoord][2] = vplanet[1][icoord][2]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][2] += 0.5*(l_2[icoord][2]-l_1[icoord][2]); 
       vplanet[1][icoord][2] += 0.5*(k_2[icoord][2]-k_1[icoord][2]); 
    } 
// update xp funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][2] = xplanet[1][icoord][2] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][2]=0.0; 
       for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][2] += xvec_ps[istar][icoord][2]*xvec_ps[istar][icoord][2]; 
        } 
    rps[istar][2] =  Math.sqrt(rpssq[istar][2]); 
    rpscube[istar][2] =  rps[istar][2]*rpssq[istar][2]; 
    } 
// calc l3 and k3 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_3[icoord][2] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_3[icoord][2] += -0.5*dtime*xvec_ps[istar][icoord][2]/rpscube[istar][2]; 
//       k_3[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_3[icoord][2] = vplanet[1][icoord][2]*dtime; 
    } 
// bump x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][2] += l_3[icoord][2]-0.5*l_2[icoord][2]; 
       vplanet[1][icoord][2] += k_3[icoord][2]-0.5*k_2[icoord][2]; 
    } 
// update funcs 
    for(int istar=1; istar<nstars; ++istar){ 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        xvec_ps[istar][icoord][2] = xplanet[1][icoord][2] - xstar[istar][icoord]; 
        } 
    } 
    for(int istar=1; istar<nstars; ++istar){ 
    rpssq[istar][2]=0.0; 
        for(int icoord=1; icoord<ncoords; ++icoord){ 
        rpssq[istar][2] += xvec_ps[istar][icoord][2]*xvec_ps[istar][icoord][2]; 
        } 
    rps[istar][2] =  Math.sqrt(rpssq[istar][2]); 
    rpscube[istar][2] =  rps[istar][2]*rpssq[istar][2]; 
        } 
// calc l4 and k4 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       k_4[icoord][2] = 0.0; 
       for(int istar=1; istar<nstars; ++istar){ 
       k_4[icoord][2] += -0.5*dtime*xvec_ps[istar][icoord][2]/rpscube[istar][2]; 
//       k_4[icoord] += -0.5*dtime*xvec_ps[istar][icoord]; 
       } 
    } 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       l_4[icoord][2] = vplanet[1][icoord][2]*dtime; 
    } 
// reset x,v 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       xplanet[1][icoord][2] += -l_3[icoord][2]; 
       vplanet[1][icoord][2] += -k_3[icoord][2]; 
    } 
 
// Runge-Kutta (4th order) updates 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
       vplanet[1][icoord][2] += (k_1[icoord][2]+2.0*k_2[icoord][2]+2.0*k_3[icoord][2]+k_4[icoord][2])/6.0; 
       xplanet[1][icoord][2] += (l_1[icoord][2]+2.0*l_2[icoord][2]+2.0*l_3[icoord][2]+l_4[icoord][2])/6.0; 
    } 
} 
 
     time +=dtime; 
} 
     dtime=2.0*dtime; 
// reset time as if we hadnt done the two half-steps 
        time  -= dtime; 
// end of method [2] RK update 
 
    if(istep == true){ 
        time  += dtime; 
    } 
 
// now do a best extrap between the two RK calcs 
    for(int icoord=1; icoord<ncoords; ++icoord){ 
    vplanet[1][icoord][3] =  vplanet[1][icoord][2] + (1.0/15.0)*(vplanet[1][icoord][2] - vplanet[1][icoord][1]); 
    xplanet[1][icoord][3] =  xplanet[1][icoord][2] + (1.0/15.0)*(xplanet[1][icoord][2] - xplanet[1][icoord][1]); 
    } 
 
// estm errors  should be   1  1  3  according to num recip 
// i think thats based on a smooth extrap and prefer 
//                          1  1  1   
// which is the real difference between the two RK extrapolations 
    xerr = Math.abs(xplanet[1][1][1] - xplanet[1][1][2]); 
    yerr = Math.abs(xplanet[1][2][1] - xplanet[1][2][2]); 
    xerrnumrecip = Math.abs(xplanet[1][1][3] - xplanet[1][1][2]); 
    yerrnumrecip = Math.abs(xplanet[1][2][3] - xplanet[1][2][2]); 
 
// axis drawing 
    if(igrid == true){ 
    g.setColor(std_blue); 
    g.drawArc(mrquart,mrquart,mrhalf,mrhalf,0,360); 
    g.drawArc(0,0,mrone,mrone,0,360);  
    g.setColor(std_blue); 
    g.drawLine(0,mrhalf,mrone,mrhalf); 
    g.drawLine(mrhalf,0,mrhalf,mrone); 
    g.drawLine(ix1, ticy1, ix1, ticy2); 
    g.drawLine(ix2, ticy1, ix2, ticy2); 
    g.drawLine(ix3, ticy1, ix3, ticy2); 
    g.drawLine(ix4, ticy1, ix4, ticy2); 
    g.drawLine(ix5, ticy1, ix5, ticy2); 
    g.drawLine(ticx1, iy1, ticx2, iy1); 
    g.drawLine(ticx1, iy2, ticx2, iy2); 
    g.drawLine(ticx1, iy3, ticx2, iy3); 
    g.drawLine(ticx1, iy4, ticx2, iy4); 
    g.drawLine(ticx1, iy5, ticx2, iy5); 
    g.setColor(std_blue); 
    g.drawString(decimalPlace(1,0.5*screenscale/radscrn)+" [AU]",3*mrquart+5,mrhalf-5); 
    g.drawString(decimalPlace(1,screenscale/radscrn)+" [AU]",mrone+5,mrhalf-5); 
    } 
// end axis drawing 
} 
 
// Dr.Guidry's patented truncatator 
 
public String decimalPlace(int nright, double number) { 
   double n = number; 
   String tright2 =""; 
   String total=String.valueOf(n); 
   int nperiod = total.indexOf("."); 
   if(nperiod == 0 || nperiod == -1) {return total;} 
   String tleft=total.substring(0,nperiod); 
   String tright=total.substring(nperiod); 
   int temp1=0, temp2=nright+1; 
   if(tright.length() > nright) { 
      try{tright2=tright.substring(temp1,temp2);} 
          catch(StringIndexOutOfBoundsException e) 
      { ; } 
   } 
   else { 
      tright2=tright; 
   } 
   return tleft+tright2; 
}  
 
 
 
/* 
 * called when the applet is started 
 * create a new instance of Thread and start it 
 */ 
//public void start() { 
// 
//        if(thread == null) { 
//                thread = new Thread(this); 
//                thread.start(); 
//        } 
//} 
 
/* 
 * called when the applet is stopped 
 * stops the thread 
 */ 
public void stop() { 
 
	thread = null; 
} 
 
/* 
 * the thread itself 
 * sleeps for (arg) ms and forces a repaint 
 */ 
public void run() { 
 
 
	while (thread != null) { 
		try { 
                        Thread.sleep(30); 
		} catch (InterruptedException e) { } 
//               repaint(ixrepp-10,iyrepp-20,120,40); 
                repaint(); 
 
//                try { 
//                        Thread.sleep(10); 
//                } catch (InterruptedException e) { } 
//                repaint(ixreps1-10,iyreps1-20,60,40); 
// 
//                try { 
//                        Thread.sleep(10); 
//                } catch (InterruptedException e) { } 
//                repaint(ixreps2-10,iyreps2-20,60,40); 
// 
//                try { 
//                        Thread.sleep(10); 
//                } catch (InterruptedException e) { } 
//                repaint(390,20,30,120);  
//                try { 
//                        Thread.sleep(10); 
//                } catch (InterruptedException e) { } 
//                repaint(320,80,150,100);  
// 
	} 
	thread = null; 
} 
 
/** 
 * override the default update method to avoid 
 * flickering caused by unnecessary erasing of the applet panel 
 * @param g - destination graphics object 
 */ 
public void update(Graphics g) { 
      Graphics offScreenGraphics = offScreenImage.getGraphics();
      offScreenGraphics.setColor(getBackground());
      offScreenGraphics.fillRect(0,0,size().width,size().height);
      offScreenGraphics.setColor(g.getColor());
      paint(offScreenGraphics);
      g.drawImage(offScreenImage,0,0,this);
//         paint(g);
} 
 
/** 
 * application entry point 
 * not used when run as an applet 
 * create a new window frame and add the applet inside 
 * @param args[] - command line arguments 
 */ 
public static void main (String args[]) { 
 
        Frame f = new Frame ("Orbit"); 
        Orbit orbit = new Orbit (); 
   
	f.resize (210, 230); 
        f.add ("Center", orbit); 
	f.show (); 
        orbit.init (); 
        orbit.start (); 
} 
} 
 
class HelpFrameO extends Frame
{
public String hstringtest;
public String textb[] = new String[31];
public Color std_yellow = new Color(255,204,  0);
public Color std_orange = new Color(255,153,  0);
public Color std_red    = new Color(204, 51,  0);
public Color std_purple = new Color(152,102,152);
public Color std_blue   = new Color(102,153,153);
public Color std_green  = new Color(153,204,153);
public Color std_white = new Color(255,255,255);
public Color std_gray1 = new Color(204,204,204);
public Color std_gray2 = new Color(153,153,153);
public Color std_gray3 = new Color(102,102,102);
public Color std_gray4 = new Color( 51, 51, 51);
HelpFrameO(String h0, String h1, String h2, String h3, String h4, String h5,
String h6, String h7, String h8, String h9, String h10, String h11,
String h12, String h13, String h14, String h15, String h16, String h17, String h18,
String h19, String h20, String h21, String h22, String h23)
  {
  hstringtest   = h0;
  textb[1]      = h1;
  textb[2]      = h2;
  textb[3]      = h3;
  textb[4]      = h4;
  textb[5]      = h5;
  textb[6]      = h6;
  textb[7]      = h7;
  textb[8]      = h8;
  textb[9]      = h9;
  textb[10]     = h10;
  textb[11]     = h11;
  textb[12]     = h12;
  textb[13]     = h13;
  textb[14]     = h14;
  textb[15]     = h15;
  textb[16]     = h16;
  textb[17]     = h17;
  textb[18]     = h18;
  textb[19]     = h19;
  textb[20]     = h20;
  textb[21]     = h21;
  textb[22]     = h22;
  textb[23]     = h23;
  }
  public void paint(Graphics g)
     {
// set up a 520x500 size data frame
     int fw = 520;
     int fh = 500;
//     resize(fw,fh);
     Font framefont = new Font("Arial", Font.PLAIN, 10);
     g.setFont(framefont);
     g.setColor(Color.black);
     g.fillRect(0,0,fw,fh);
     g.setColor(Color.green);
     g.drawString(hstringtest,30,50);
     g.setColor(Color.cyan);
     int ihwrite = 80;
     g.drawString("FUNCTIONS:",30,ihwrite);
     ihwrite+=15;
     int itextloop;
     for(itextloop=1; itextloop<14; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }
     ihwrite+=15;
     g.setColor(std_yellow);
     for(itextloop=14; itextloop<31; ++itextloop){
     if(textb[itextloop] != ""){
     g.drawString(textb[itextloop],30,ihwrite);
     ihwrite+=15;
     }
     }

     }

  public boolean handleEvent(Event evt)
     {
     switch(evt.id)
     {
        case Event.WINDOW_DESTROY:
        dispose();
        return true;
     }
     return false;
     }

}

// thats all folks
