/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;

public class Orbit
extends Applet
implements Runnable {
    Panel panelH = new Panel();
    Panel panelV = new Panel();
    Panel panelv1 = new Panel();
    Button button0v;
    Button button1v;
    Button button2v;
    Button button3v;
    Button button4v;
    Button button5v;
    Button button6v;
    Button button7v;
    Button button8v;
    Button button9v;
    Button button10v;
    Button button1h;
    Button button2h;
    Scrollbar sth0;
    Scrollbar sa0;
    Scrollbar sx0;
    Scrollbar sv0;
    HelpFrameO helpframe;
    Thread thread = null;
    public static double vconvert = 29.7653;
    public double vy0kmps;
    public double thstars;
    public double astars;
    public int nstars = 3;
    public int nplanets = 2;
    public int ncoords = 4;
    public int nmethods = 4;
    public Label labelth0 = new Label("", 1);
    public Label labela0 = new Label("", 1);
    public Label labelx0 = new Label("", 1);
    public Label labelv0 = new Label("", 1);
    public Label labelth0text = new Label("Initial theta", 1);
    public Label labela0text = new Label("Initial a(stars)", 1);
    public Label labelx0text = new Label("Initial x(planet)", 1);
    public Label labelv0text = new Label("Initial v_y(planet)", 1);
    public double[][] xstar = new double[this.nstars][this.ncoords];
    public double[][] vstar = new double[this.nstars][this.ncoords];
    public double[][][] xplanet = new double[this.nplanets][this.ncoords][this.nmethods];
    public double[][][] vplanet = new double[this.nplanets][this.ncoords][this.nmethods];
    public double[][][] xvec_ps = new double[this.nstars][this.ncoords][this.nmethods];
    public double[][] xps = new double[this.nstars][this.nmethods];
    public double[][] yps = new double[this.nstars][this.nmethods];
    public double[][] rps = new double[this.nstars][this.nmethods];
    public double[][] rpssq = new double[this.nstars][this.nmethods];
    public double[][] rpscube = new double[this.nstars][this.nmethods];
    public double[][] k_1 = new double[this.ncoords][this.nmethods];
    public double[][] k_2 = new double[this.ncoords][this.nmethods];
    public double[][] k_3 = new double[this.ncoords][this.nmethods];
    public double[][] k_4 = new double[this.ncoords][this.nmethods];
    public double[][] l_1 = new double[this.ncoords][this.nmethods];
    public double[][] l_2 = new double[this.ncoords][this.nmethods];
    public double[][] l_3 = new double[this.ncoords][this.nmethods];
    public double[][] l_4 = new double[this.ncoords][this.nmethods];
    public double xerr = 0.0;
    public double yerr = 0.0;
    public double xerrnumrecip = 0.0;
    public double yerrnumrecip = 0.0;
    public int ipalette = 1;
    public Color ai_textcolor = new Color(144, 196, 196);
    Image[] imgstar = new Image[this.nstars];
    public Color std_yellow = new Color(255, 204, 0);
    public Color std_orange = new Color(255, 153, 0);
    public Color std_red = new Color(204, 51, 0);
    public Color std_purple = new Color(152, 102, 152);
    public Color std_blue = new Color(102, 153, 153);
    public Color std_green = new Color(153, 204, 153);
    public Color std_white = new Color(255, 255, 255);
    public Color std_gray1 = new Color(204, 204, 204);
    public Color std_gray2 = new Color(153, 153, 153);
    public Color std_gray3 = new Color(102, 102, 102);
    public Color std_gray4 = new Color(51, 51, 51);
    public double screenscale;
    private Image offScreenImage;
    public double radscrn;
    public double rdisplaymax = 1.1;
    public double rdisplaymin = 0.4;
    public static double pi = Math.PI;
    public double dtime0 = 0.01;
    public int iresol = 0;
    public double dtime = this.dtime0 * Math.pow(2.0, this.iresol);
    public double time = 0.0;
    public double xreal;
    public double yreal;
    public double vx;
    public double vy;
    public boolean istep = false;
    public boolean ierrbox = true;
    public boolean ishowbc = true;
    public boolean idata = true;
    public boolean igrid = true;
    public boolean ilabels = true;
    public int ix1;
    public int ix2;
    public int ix3;
    public int ix4;
    public int ix5;
    public int iy1;
    public int iy2;
    public int iy3;
    public int iy4;
    public int iy5;
    public int ticx1;
    public int ticx2;
    public int ticy1;
    public int ticy2;
    public int mrone;
    public int mrhalf;
    public int mrquart;
    public int ixrepp;
    public int iyrepp;
    public int ixreps1;
    public int iyreps1;
    public int ixreps2;
    public int iyreps2;

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button && object == "About") {
            this.helpframe = new HelpFrameO("This is a Java simulation of a planet orbiting a double star.", "The basic functions of the applet are as follows:", "'Start/Stop' begins and pauses the simulation.", "'Reset' return the simulation to time=0.", "'Grid' shows a calibrated length scale in [AU], centered on the stars' c.o.g.", "'Labels' identifies the stars and the planet.", "'Data' shows the elapsed time in [yrs], the planet's distance from the stars' c.o.g. in [AU],", "     and the planet's velocity in [km/sec] and estimated temp assuming the Earth's albedo.", "'Finer' halves the time step size dtime, making the predicted positions approx 16x more accurate.", "'Coarser' doubles the time step dtime, which gives a faster but less accurate simulation.", "An error box shows estimated position errors as two faint gray rectangles.", "     If these become visible, 'Reset' and decrease dtime using 'Finer'.", "The parameters can be changed by using the sliders followed by 'Start'.", " ", "THE SIMULATION:", "The stars are placed in a circular orbit with the specified orbit parameters.", "Each star is taken to have 1/2 solar mass and luminosity.", "F=ma is then integrated numerically for the planet with the specified initial conditions,", "using two successive Runge-Kutta integrations. These are extrapolated as recommended in", "Numerical Recipies, and the extrapolated position is shown as a plus sign.", "The Num. Rec. estimated position error is shown as the smaller gray box.", "and the difference between the two unextrapolated Runge-Kutta simulations is the larger gray box.", "                                                                       Java programming by Ted Barnes", "");
            this.helpframe.resize(520, 500);
            this.helpframe.move(0, 0);
            this.helpframe.show();
            this.istep = false;
            this.repaint();
            this.istep = true;
        }
        if (event.target instanceof Button && object == "Start") {
            this.thread = new Thread(this);
            if (this.ipalette == 3) {
                this.button1v.setBackground(new Color(0, 255, 0));
                this.button3v.setBackground(new Color(200, 100, 100));
                this.panelV.add(this.button1v);
                this.panelV.add(this.button3v);
            }
            this.thread.start();
            this.istep = false;
            this.button1v.setLabel("Stop");
            this.repaint();
            this.istep = true;
        }
        if (event.target instanceof Button && object == "Reset") {
            this.button1v.setLabel("Start");
            if (this.ipalette == 3) {
                this.button1v.setBackground(new Color(100, 200, 100));
                this.button3v.setBackground(new Color(200, 100, 100));
            }
            this.panelV.add(this.button1v);
            this.panelV.add(this.button3v);
            this.thread = null;
            this.istep = false;
            this.repaint();
            this.time = 0.0;
            this.dtime = this.dtime0;
            this.iresol = 0;
            this.thstars = this.sth0.getValue();
            this.astars = 0.01 * (double)this.sa0.getValue();
            this.xreal = 0.02 * (double)this.sx0.getValue();
            this.vx = 0.0;
            this.vy0kmps = 0.1 * (double)this.sv0.getValue();
            this.vy = 1.0 / vconvert * this.vy0kmps;
            this.yreal = 0.0;
            int n = 1;
            while (n < this.nmethods) {
                this.vplanet[1][1][n] = 0.0;
                this.vplanet[1][2][n] = 1.0 / vconvert * this.vy0kmps;
                this.xplanet[1][1][n] = 0.02 * (double)this.sx0.getValue();
                this.xplanet[1][2][n] = 0.0;
                ++n;
            }
        }
        if (event.target instanceof Button && object == "Start" && this.thread == null) {
            if (this.ipalette == 3) {
                this.button1v.setBackground(new Color(0, 255, 0));
                this.button3v.setBackground(new Color(200, 100, 100));
            }
            this.button1v.setLabel("Stop");
            this.panelV.add(this.button1v);
            this.panelV.add(this.button3v);
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (object == "Stop") {
            if (this.ipalette == 3) {
                this.button1v.setBackground(new Color(100, 200, 100));
            }
            this.button1v.setLabel("Start");
            this.panelV.add(this.button1v);
            this.istep = false;
            this.repaint();
            this.thread = null;
            this.istep = false;
        }
        if (object == "Grid") {
            this.igrid ^= true;
            if (this.ipalette == 3) {
                if (!this.igrid) {
                    this.button4v.setBackground(Color.gray);
                    this.button4v.setForeground(Color.darkGray);
                }
                if (this.igrid) {
                    this.button4v.setBackground(new Color(100, 100, 255));
                    this.button4v.setForeground(Color.black);
                }
                this.panelV.add(this.button4v);
            }
            this.istep = false;
            this.repaint();
            if (this.thread != null) {
                this.istep = true;
            }
        }
        if (object == "Data") {
            this.idata ^= true;
            if (this.ipalette == 3) {
                if (!this.idata) {
                    this.button5v.setBackground(Color.gray);
                    this.button5v.setForeground(Color.darkGray);
                }
                if (this.idata) {
                    this.button5v.setBackground(new Color(100, 100, 255));
                    this.button5v.setForeground(Color.black);
                }
                this.panelV.add(this.button5v);
            }
            this.istep = false;
            this.repaint();
            if (this.thread != null) {
                this.istep = true;
            }
        }
        if (object == "Labels") {
            this.ilabels ^= true;
            if (this.ipalette == 3) {
                if (!this.ilabels) {
                    this.button6v.setBackground(Color.gray);
                    this.button6v.setForeground(Color.darkGray);
                }
                if (this.ilabels) {
                    this.button6v.setBackground(new Color(100, 100, 255));
                    this.button6v.setForeground(Color.black);
                }
                this.panelV.add(this.button6v);
            }
            this.istep = false;
            this.repaint();
            if (this.thread != null) {
                this.istep = true;
            }
        }
        if (object == "Finer") {
            this.ishowbc = true;
            --this.iresol;
            this.dtime = this.dtime0 * Math.pow(2.0, this.iresol);
            this.istep = false;
            this.repaint();
            if (this.thread != null) {
                this.istep = true;
            }
        }
        if (object == "Coarser") {
            this.ishowbc = true;
            ++this.iresol;
            this.dtime = this.dtime0 * Math.pow(2.0, this.iresol);
            this.istep = false;
            this.repaint();
            if (this.thread != null) {
                this.istep = true;
            }
        }
        return true;
    }

    public String decimalPlace(int n, double d) {
        double d2 = d;
        String string = "";
        String string2 = String.valueOf(d2);
        int n2 = string2.indexOf(".");
        if (n2 == 0 || n2 == -1) {
            return string2;
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2);
        int n3 = 0;
        int n4 = n + 1;
        if (string4.length() > n) {
            try {
                string = string4.substring(n3, n4);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            string = string4;
        }
        return String.valueOf(string3) + string;
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Scrollbar) {
            this.button1v.setLabel("Start");
            this.thread = null;
            this.ishowbc = true;
            this.time = 0.0;
            this.thstars = this.sth0.getValue();
            this.astars = 0.01 * (double)this.sa0.getValue();
            this.xreal = 0.02 * (double)this.sx0.getValue();
            this.vx = 0.0;
            this.vy0kmps = 0.1 * (double)this.sv0.getValue();
            this.vy = 1.0 / vconvert * this.vy0kmps;
            this.yreal = 0.0;
            this.labelth0.setText(String.valueOf(String.valueOf(this.decimalPlace(0, this.thstars))) + " [deg]");
            this.labela0.setText(String.valueOf(String.valueOf(this.decimalPlace(2, this.astars))) + " [AU]");
            this.labelx0.setText(String.valueOf(String.valueOf(this.decimalPlace(2, this.xreal))) + " [AU]");
            this.labelv0.setText(String.valueOf(String.valueOf(this.decimalPlace(1, this.vy0kmps))) + " [km/sec]");
            int n = 1;
            while (n < this.nmethods) {
                this.vplanet[1][1][n] = 0.0;
                this.vplanet[1][2][n] = 1.0 / vconvert * this.vy0kmps;
                this.xplanet[1][1][n] = 0.02 * (double)this.sx0.getValue();
                this.xplanet[1][2][n] = 0.0;
                ++n;
            }
            this.istep = false;
            this.repaint();
            return true;
        }
        boolean bl = super.handleEvent(event);
        return bl;
    }

    public void init() {
        this.offScreenImage = this.createImage(this.size().width, this.size().height);
        this.imgstar[1] = this.getImage(this.getDocumentBase(), "sun_yellow.jpg");
        this.imgstar[2] = this.getImage(this.getDocumentBase(), "sun_yellow.jpg");
        Dimension dimension = this.size();
        this.radscrn = this.screenscale = 0.9 * (double)dimension.height;
        this.mrone = (int)this.screenscale;
        this.mrhalf = (int)(0.5 * this.screenscale);
        this.mrquart = (int)(0.25 * this.screenscale);
        this.ticy1 = (int)(0.48 * this.screenscale);
        this.ticy2 = (int)(0.52 * this.screenscale);
        this.ix1 = 0;
        this.ix2 = this.mrquart;
        this.ix3 = this.mrhalf;
        this.ix4 = 3 * this.mrquart;
        this.ix5 = this.mrone;
        this.ticx1 = this.ticy1;
        this.ticx2 = this.ticy2;
        this.iy1 = 0;
        this.iy2 = this.mrquart;
        this.iy3 = this.mrhalf;
        this.iy4 = 3 * this.mrquart;
        this.iy5 = this.mrone;
        this.setBackground(Color.black);
        this.setLayout(null);
        this.panelV.setLayout(null);
        this.panelV.setBounds(0, 320, 520, 20);
        this.add(this.panelV);
        this.button0v = new Button("About");
        this.button1v = new Button("Start");
        this.button3v = new Button("Reset");
        this.button4v = new Button("Grid");
        this.button5v = new Button("Data");
        this.button6v = new Button("Labels");
        this.button7v = new Button("Finer");
        this.button8v = new Button("Coarser");
        int n = 75;
        this.button1v.setBounds(0, 0, 55, 20);
        this.button3v.setBounds(n, 0, 55, 20);
        this.button4v.setBounds(2 * n, 0, 55, 20);
        this.button6v.setBounds(3 * n, 0, 55, 20);
        this.button5v.setBounds(4 * n, 0, 55, 20);
        this.button7v.setBounds(5 * n, 0, 55, 20);
        this.button8v.setBounds(6 * n, 0, 55, 20);
        this.button0v.setBounds(6 * n + 1, 0, 55, 20);
        this.panelV.add(this.button1v);
        this.panelV.add(this.button3v);
        this.panelV.add(this.button4v);
        this.panelV.add(this.button6v);
        this.panelV.add(this.button5v);
        this.panelV.add(this.button7v);
        this.panelV.add(this.button8v);
        this.panelV.add(this.button0v);
        if (this.ipalette == 1) {
            this.button0v.setBackground(this.std_gray2);
            this.button1v.setBackground(this.std_gray2);
            this.button3v.setBackground(this.std_gray2);
            this.button4v.setBackground(this.std_gray2);
            this.button5v.setBackground(this.std_gray2);
            this.button6v.setBackground(this.std_gray2);
            this.button7v.setBackground(this.std_gray2);
            this.button8v.setBackground(this.std_gray2);
        }
        if (this.ipalette == 3) {
            this.button1v.setBackground(new Color(100, 200, 100));
            this.button3v.setBackground(new Color(200, 100, 100));
            this.button4v.setBackground(new Color(100, 100, 255));
            this.button5v.setBackground(new Color(100, 100, 255));
            this.button6v.setBackground(new Color(100, 100, 255));
            this.button7v.setBackground(new Color(100, 100, 255));
            this.button8v.setBackground(new Color(100, 100, 255));
            this.button0v.setBackground(new Color(200, 0, 200));
        }
        this.panelv1.setLayout(null);
        this.panelv1.setBounds(420, 0, 100, 320);
        this.add(this.panelv1);
        this.sth0 = new Scrollbar(0, 0, 1, 0, 181);
        this.sa0 = new Scrollbar(0, 0, 1, 1, 101);
        this.sx0 = new Scrollbar(0, 0, 1, 0, 101);
        this.sv0 = new Scrollbar(0, 0, 1, -1001, 1001);
        this.sth0.setValue(0);
        this.sa0.setValue(40);
        this.sx0.setValue(50);
        this.sv0.setValue(320);
        this.thstars = this.sth0.getValue();
        this.astars = 0.01 * (double)this.sa0.getValue();
        this.xreal = 0.02 * (double)this.sx0.getValue();
        this.vy0kmps = 0.1 * (double)this.sv0.getValue();
        this.labelth0.setText(String.valueOf(String.valueOf(this.decimalPlace(0, this.thstars))) + " [deg]");
        this.labela0.setText(String.valueOf(String.valueOf(this.decimalPlace(2, this.astars))) + " [AU]");
        this.labelx0.setText(String.valueOf(String.valueOf(this.decimalPlace(2, this.xreal))) + " [AU]");
        this.labelv0.setText(String.valueOf(String.valueOf(this.decimalPlace(1, this.vy0kmps))) + " [km/sec]");
        this.sth0.setBounds(0, 60, 100, 15);
        this.sth0.setBackground(this.std_gray2);
        this.panelv1.add(this.sth0);
        this.sa0.setBounds(0, 120, 100, 15);
        this.sa0.setBackground(this.std_gray2);
        this.panelv1.add(this.sa0);
        this.sx0.setBounds(0, 180, 100, 15);
        this.sx0.setBackground(this.std_gray2);
        this.panelv1.add(this.sx0);
        this.sv0.setBounds(0, 240, 100, 15);
        this.sv0.setBackground(this.std_gray2);
        this.panelv1.add(this.sv0);
        this.labelth0text.setBounds(0, 25, 100, 15);
        this.labelth0text.setForeground(this.std_gray1);
        this.labelth0text.setBackground(Color.black);
        this.panelv1.add(this.labelth0text);
        this.labelth0.setBounds(0, 40, 100, 15);
        this.labelth0.setForeground(this.std_gray1);
        this.labelth0.setBackground(Color.black);
        this.panelv1.add(this.labelth0);
        this.labela0text.setBounds(0, 85, 100, 15);
        this.labela0text.setForeground(this.std_gray1);
        this.labela0text.setBackground(Color.black);
        this.panelv1.add(this.labela0text);
        this.labela0.setBounds(0, 100, 100, 15);
        this.labela0.setForeground(this.std_gray1);
        this.labela0.setBackground(Color.black);
        this.panelv1.add(this.labela0);
        this.labelx0text.setBounds(0, 145, 100, 15);
        this.labelx0text.setForeground(this.std_gray1);
        this.labelx0text.setBackground(Color.black);
        this.panelv1.add(this.labelx0text);
        this.labelx0.setBounds(0, 160, 100, 15);
        this.labelx0.setForeground(this.std_gray1);
        this.labelx0.setBackground(Color.black);
        this.panelv1.add(this.labelx0);
        this.labelv0text.setBounds(0, 205, 100, 15);
        this.labelv0text.setForeground(this.std_gray1);
        this.labelv0text.setBackground(Color.black);
        this.panelv1.add(this.labelv0text);
        this.labelv0.setBounds(0, 220, 100, 15);
        this.labelv0.setForeground(this.std_gray1);
        this.labelv0.setBackground(Color.black);
        this.panelv1.add(this.labelv0);
        this.time = 0.0;
        this.thstars = this.sth0.getValue();
        this.astars = 0.01 * (double)this.sa0.getValue();
        this.xreal = 0.02 * (double)this.sx0.getValue();
        this.vx = 0.0;
        this.vy0kmps = 0.1 * (double)this.sv0.getValue();
        this.vy = this.vy0kmps / vconvert;
        this.yreal = 0.0;
        int n2 = 1;
        while (n2 < this.nmethods) {
            this.vplanet[1][1][n2] = 0.0;
            this.vplanet[1][2][n2] = 1.0 / vconvert * this.vy0kmps;
            this.xplanet[1][1][n2] = 0.02 * (double)this.sx0.getValue();
            this.xplanet[1][2][n2] = 0.0;
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Orbit");
        Orbit orbit = new Orbit();
        frame.resize(210, 230);
        frame.add("Center", orbit);
        frame.show();
        orbit.init();
        orbit.start();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        double d;
        int n23;
        int n24;
        Font font = new Font("Arial", 0, 11);
        graphics.setFont(font);
        String[] stringArray = new String[20];
        String[] stringArray2 = new String[this.nstars];
        stringArray2[1] = "  Star A";
        stringArray2[2] = "  Star B";
        stringArray[2] = "  die Welt";
        stringArray[7] = "T(estm) =            [K]";
        stringArray[8] = " [C]";
        stringArray[9] = " [F]";
        stringArray[10] = "Set initial a(stars) ";
        stringArray[11] = "[AU]";
        stringArray[12] = "Set initial x(planet) ";
        stringArray[13] = "[AU]";
        stringArray[14] = "  Set initial v_y ";
        stringArray[15] = "   [km/sec]";
        stringArray[16] = "  Runge-Kutta";
        stringArray[17] = "  Runge-Kutta higher resol.";
        stringArray[18] = "   planet";
        double d2 = this.time / (2.0 * pi);
        double d3 = 0.0;
        double d4 = 0.0;
        int n25 = 1;
        while (n25 < this.ncoords) {
            d3 += this.vplanet[1][n25][3] * this.vplanet[1][n25][3];
            d4 += this.xplanet[1][n25][3] * this.xplanet[1][n25][3];
            ++n25;
        }
        d3 = Math.sqrt(d3);
        if ((d4 = Math.sqrt(d4)) > this.rdisplaymax && this.rdisplaymax < 50.0) {
            this.radscrn = 0.5 * this.radscrn;
            this.repaint();
            this.rdisplaymax = 2.0 * this.rdisplaymax;
            this.rdisplaymin = 2.0 * this.rdisplaymin;
        }
        if (d4 < this.rdisplaymin && this.rdisplaymin > 0.5) {
            this.radscrn = 2.0 * this.radscrn;
            this.repaint();
            this.rdisplaymax = 0.5 * this.rdisplaymax;
            this.rdisplaymin = 0.5 * this.rdisplaymin;
        }
        this.thstars = this.sth0.getValue();
        double d5 = this.astars * Math.sqrt(this.astars);
        this.xstar[1][1] = this.astars * Math.cos(this.time / d5 + pi * (this.thstars / 180.0));
        this.xstar[1][2] = this.astars * Math.sin(this.time / d5 + pi * (this.thstars / 180.0));
        this.xstar[2][1] = -this.xstar[1][1];
        this.xstar[2][2] = -this.xstar[1][2];
        graphics.setColor(Color.yellow);
        int n26 = (int)(0.5 * this.screenscale + 0.5 * this.radscrn * this.xstar[1][1]);
        int n27 = (int)(0.5 * this.screenscale - 0.5 * this.radscrn * this.xstar[1][2]);
        int n28 = Math.max(2, (int)Math.round(Math.sqrt(30.0 * this.radscrn / this.screenscale)));
        graphics.drawImage(this.imgstar[1], n26 - n28, n27 - n28, 2 * n28, 2 * n28, this);
        if (this.ilabels) {
            graphics.drawString(stringArray2[1], n26, n27);
        }
        this.ixreps1 = n26;
        this.iyreps1 = n27;
        n26 = (int)(0.5 * this.screenscale + 0.5 * this.radscrn * this.xstar[2][1]);
        n27 = (int)(0.5 * this.screenscale - 0.5 * this.radscrn * this.xstar[2][2]);
        graphics.drawImage(this.imgstar[2], n26 - n28, n27 - n28, 2 * n28, 2 * n28, this);
        if (this.ilabels) {
            graphics.drawString(stringArray2[2], n26, n27);
        }
        this.ixreps2 = n26;
        this.iyreps2 = n27;
        int n29 = 1;
        while (n29 < this.nmethods) {
            n24 = 1;
            while (n24 < this.nstars) {
                n23 = 1;
                while (n23 < this.ncoords) {
                    this.xvec_ps[n24][n23][n29] = this.xplanet[1][n23][n29] - this.xstar[n24][n23];
                    ++n23;
                }
                ++n24;
            }
            ++n29;
        }
        n24 = 1;
        while (n24 < this.nmethods) {
            n23 = 1;
            while (n23 < this.nstars) {
                this.rpssq[n23][n24] = 0.0;
                int n30 = 1;
                while (n30 < this.ncoords) {
                    double[] dArray = this.rpssq[n23];
                    int n31 = n24;
                    dArray[n31] = dArray[n31] + this.xvec_ps[n23][n30][n24] * this.xvec_ps[n23][n30][n24];
                    ++n30;
                }
                this.rps[n23][n24] = Math.sqrt(this.rpssq[n23][n24]);
                this.rpscube[n23][n24] = this.rps[n23][n24] * this.rpssq[n23][n24];
                ++n23;
            }
            ++n24;
        }
        double d6 = Math.min(this.rps[1][1], this.rps[2][1]);
        double d7 = Math.min(d6, d = Math.min(this.rps[1][2], this.rps[2][2]));
        if (d7 > 0.1) {
            this.dtime = this.dtime0 * Math.pow(2.0, this.iresol);
        }
        if (d7 < 0.1) {
            this.dtime = 0.001;
        }
        double d8 = 146.58 * (Math.sqrt(1.0 / this.rps[1][3]) + Math.sqrt(1.0 / this.rps[2][3]));
        double d9 = d8 - 273.16;
        double d10 = 1.8 * d8 - 459.69;
        n26 = (int)(0.5 * this.screenscale + 0.5 * this.radscrn * this.xplanet[1][1][3]);
        n27 = (int)(0.5 * this.screenscale - 0.5 * this.radscrn * this.xplanet[1][2][3]);
        if (this.ierrbox) {
            graphics.setColor(this.std_gray2);
            n22 = (int)(0.25 * this.radscrn * this.xerr);
            n21 = (int)(0.25 * this.radscrn * this.yerr);
            graphics.drawRect(n26 - n22, n27 - n21, 2 * n22, 2 * n21);
            graphics.setColor(this.std_gray2);
            n22 = (int)(0.25 * this.radscrn * this.xerrnumrecip);
            n21 = (int)(0.25 * this.radscrn * this.yerrnumrecip);
            graphics.drawRect(n26 - n22, n27 - n21, 2 * n22, 2 * n21);
        }
        n22 = 0;
        n21 = 0;
        int n32 = 0;
        if (d9 > 100.0) {
            n22 = 255;
            n21 = 0;
            n32 = 0;
        }
        if (d9 < 100.0 && d9 > 0.0) {
            n22 = (int)(255.0 * d9 / 100.0);
            n21 = 255;
            n32 = 0;
        }
        if (d9 < 0.0) {
            n22 = 0;
            n21 = (int)(255.0 * d8 / 273.16);
            n32 = 255;
        }
        graphics.setColor(new Color(n22, n21, n32));
        graphics.drawLine(n26, n27 - 2, n26, n27 + 2);
        graphics.drawLine(n26 - 2, n27, n26 + 2, n27);
        this.ixrepp = n26;
        this.iyrepp = n27;
        if (this.ilabels) {
            graphics.drawString(stringArray[18], n26, n27);
        }
        if (this.idata) {
            graphics.setColor(this.std_gray4);
            graphics.fillRect(305, 5, 105, 95);
            graphics.setColor(this.std_gray2);
            graphics.drawRect(305, 5, 105, 95);
            graphics.setColor(this.std_gray1);
            graphics.drawString("time =     " + this.decimalPlace(2, d2) + " [yrs]", 310, 20);
            graphics.drawString("d_cog =  " + this.decimalPlace(2, d4) + " [AU]", 310, 35);
            double d11 = vconvert * d3;
            graphics.drawString("v =        " + this.decimalPlace(1, d11) + " [km/s]", 310, 50);
            graphics.setColor(new Color(n22, n21, n32));
            graphics.drawString(stringArray[7], 310, 65);
            graphics.drawString(String.valueOf((int)d8), 370, 65);
            graphics.drawString(String.valueOf(String.valueOf((int)d9)) + stringArray[8], 370, 80);
            graphics.drawString(String.valueOf(String.valueOf((int)d10)) + stringArray[9], 370, 95);
        }
        if (this.ishowbc) {
            graphics.setColor(this.std_gray2);
            graphics.drawString("dtime=" + this.decimalPlace(2, this.dtime0) + "*2^" + String.valueOf(this.iresol - 1) + "/pi [yrs]", 300, 300);
        }
        this.xstar[1][1] = this.astars * Math.cos(this.time / d5 + pi * (this.thstars / 180.0));
        this.xstar[1][2] = this.astars * Math.sin(this.time / d5 + pi * (this.thstars / 180.0));
        this.xstar[2][1] = -this.xstar[1][1];
        this.xstar[2][2] = -this.xstar[1][2];
        int n33 = 1;
        while (n33 < this.nstars) {
            n20 = 1;
            while (n20 < this.ncoords) {
                this.xvec_ps[n33][n20][1] = this.xplanet[1][n20][1] - this.xstar[n33][n20];
                ++n20;
            }
            ++n33;
        }
        n20 = 1;
        while (n20 < this.nstars) {
            this.rpssq[n20][1] = 0.0;
            n19 = 1;
            while (n19 < this.ncoords) {
                double[] dArray = this.rpssq[n20];
                dArray[1] = dArray[1] + this.xvec_ps[n20][n19][1] * this.xvec_ps[n20][n19][1];
                ++n19;
            }
            this.rps[n20][1] = Math.sqrt(this.rpssq[n20][1]);
            this.rpscube[n20][1] = this.rps[n20][1] * this.rpssq[n20][1];
            ++n20;
        }
        if (this.istep) {
            n19 = 1;
            while (n19 < this.ncoords) {
                this.k_1[n19][1] = 0.0;
                n18 = 1;
                while (n18 < this.nstars) {
                    double[] dArray = this.k_1[n19];
                    dArray[1] = dArray[1] + -0.5 * this.dtime * this.xvec_ps[n18][n19][1] / this.rpscube[n18][1];
                    ++n18;
                }
                ++n19;
            }
            n18 = 1;
            while (n18 < this.ncoords) {
                this.l_1[n18][1] = this.vplanet[1][n18][1] * this.dtime;
                ++n18;
            }
            n17 = 1;
            while (n17 < this.ncoords) {
                double[] dArray = this.xplanet[1][n17];
                dArray[1] = dArray[1] + 0.5 * this.l_1[n17][1];
                double[] dArray2 = this.vplanet[1][n17];
                dArray2[1] = dArray2[1] + 0.5 * this.k_1[n17][1];
                ++n17;
            }
            n16 = 1;
            while (n16 < this.nstars) {
                n15 = 1;
                while (n15 < this.ncoords) {
                    this.xvec_ps[n16][n15][1] = this.xplanet[1][n15][1] - this.xstar[n16][n15];
                    ++n15;
                }
                ++n16;
            }
            n15 = 1;
            while (n15 < this.nstars) {
                this.rpssq[n15][1] = 0.0;
                n14 = 1;
                while (n14 < this.ncoords) {
                    double[] dArray = this.rpssq[n15];
                    dArray[1] = dArray[1] + this.xvec_ps[n15][n14][1] * this.xvec_ps[n15][n14][1];
                    ++n14;
                }
                this.rps[n15][1] = Math.sqrt(this.rpssq[n15][1]);
                this.rpscube[n15][1] = this.rps[n15][1] * this.rpssq[n15][1];
                ++n15;
            }
            n14 = 1;
            while (n14 < this.ncoords) {
                this.k_2[n14][1] = 0.0;
                n13 = 1;
                while (n13 < this.nstars) {
                    double[] dArray = this.k_2[n14];
                    dArray[1] = dArray[1] + -0.5 * this.dtime * this.xvec_ps[n13][n14][1] / this.rpscube[n13][1];
                    ++n13;
                }
                ++n14;
            }
            n13 = 1;
            while (n13 < this.ncoords) {
                this.l_2[n13][1] = this.vplanet[1][n13][1] * this.dtime;
                ++n13;
            }
            n12 = 1;
            while (n12 < this.ncoords) {
                double[] dArray = this.xplanet[1][n12];
                dArray[1] = dArray[1] + 0.5 * (this.l_2[n12][1] - this.l_1[n12][1]);
                double[] dArray3 = this.vplanet[1][n12];
                dArray3[1] = dArray3[1] + 0.5 * (this.k_2[n12][1] - this.k_1[n12][1]);
                ++n12;
            }
            n11 = 1;
            while (n11 < this.nstars) {
                n10 = 1;
                while (n10 < this.ncoords) {
                    this.xvec_ps[n11][n10][1] = this.xplanet[1][n10][1] - this.xstar[n11][n10];
                    ++n10;
                }
                ++n11;
            }
            n10 = 1;
            while (n10 < this.nstars) {
                this.rpssq[n10][1] = 0.0;
                n9 = 1;
                while (n9 < this.ncoords) {
                    double[] dArray = this.rpssq[n10];
                    dArray[1] = dArray[1] + this.xvec_ps[n10][n9][1] * this.xvec_ps[n10][n9][1];
                    ++n9;
                }
                this.rps[n10][1] = Math.sqrt(this.rpssq[n10][1]);
                this.rpscube[n10][1] = this.rps[n10][1] * this.rpssq[n10][1];
                ++n10;
            }
            n9 = 1;
            while (n9 < this.ncoords) {
                this.k_3[n9][1] = 0.0;
                n8 = 1;
                while (n8 < this.nstars) {
                    double[] dArray = this.k_3[n9];
                    dArray[1] = dArray[1] + -0.5 * this.dtime * this.xvec_ps[n8][n9][1] / this.rpscube[n8][1];
                    ++n8;
                }
                ++n9;
            }
            n8 = 1;
            while (n8 < this.ncoords) {
                this.l_3[n8][1] = this.vplanet[1][n8][1] * this.dtime;
                ++n8;
            }
            n7 = 1;
            while (n7 < this.ncoords) {
                double[] dArray = this.xplanet[1][n7];
                dArray[1] = dArray[1] + (this.l_3[n7][1] - 0.5 * this.l_2[n7][1]);
                double[] dArray4 = this.vplanet[1][n7];
                dArray4[1] = dArray4[1] + (this.k_3[n7][1] - 0.5 * this.k_2[n7][1]);
                ++n7;
            }
            n6 = 1;
            while (n6 < this.nstars) {
                n5 = 1;
                while (n5 < this.ncoords) {
                    this.xvec_ps[n6][n5][1] = this.xplanet[1][n5][1] - this.xstar[n6][n5];
                    ++n5;
                }
                ++n6;
            }
            n5 = 1;
            while (n5 < this.nstars) {
                this.rpssq[n5][1] = 0.0;
                n4 = 1;
                while (n4 < this.ncoords) {
                    double[] dArray = this.rpssq[n5];
                    dArray[1] = dArray[1] + this.xvec_ps[n5][n4][1] * this.xvec_ps[n5][n4][1];
                    ++n4;
                }
                this.rps[n5][1] = Math.sqrt(this.rpssq[n5][1]);
                this.rpscube[n5][1] = this.rps[n5][1] * this.rpssq[n5][1];
                ++n5;
            }
            n4 = 1;
            while (n4 < this.ncoords) {
                this.k_4[n4][1] = 0.0;
                n3 = 1;
                while (n3 < this.nstars) {
                    double[] dArray = this.k_4[n4];
                    dArray[1] = dArray[1] + -0.5 * this.dtime * this.xvec_ps[n3][n4][1] / this.rpscube[n3][1];
                    ++n3;
                }
                ++n4;
            }
            n3 = 1;
            while (n3 < this.ncoords) {
                this.l_4[n3][1] = this.vplanet[1][n3][1] * this.dtime;
                ++n3;
            }
            n2 = 1;
            while (n2 < this.ncoords) {
                double[] dArray = this.xplanet[1][n2];
                dArray[1] = dArray[1] + -this.l_3[n2][1];
                double[] dArray5 = this.vplanet[1][n2];
                dArray5[1] = dArray5[1] + -this.k_3[n2][1];
                ++n2;
            }
            n = 1;
            while (n < this.ncoords) {
                double[] dArray = this.vplanet[1][n];
                dArray[1] = dArray[1] + (this.k_1[n][1] + 2.0 * this.k_2[n][1] + 2.0 * this.k_3[n][1] + this.k_4[n][1]) / 6.0;
                double[] dArray6 = this.xplanet[1][n];
                dArray6[1] = dArray6[1] + (this.l_1[n][1] + 2.0 * this.l_2[n][1] + 2.0 * this.l_3[n][1] + this.l_4[n][1]) / 6.0;
                ++n;
            }
        }
        this.dtime = 0.5 * this.dtime;
        n19 = 1;
        while (n19 < 3) {
            this.xstar[1][1] = this.astars * Math.cos(this.time / d5 + pi * (this.thstars / 180.0));
            this.xstar[1][2] = this.astars * Math.sin(this.time / d5 + pi * (this.thstars / 180.0));
            this.xstar[2][1] = -this.xstar[1][1];
            this.xstar[2][2] = -this.xstar[1][2];
            n18 = 1;
            while (n18 < this.nstars) {
                n17 = 1;
                while (n17 < this.ncoords) {
                    this.xvec_ps[n18][n17][2] = this.xplanet[1][n17][2] - this.xstar[n18][n17];
                    ++n17;
                }
                ++n18;
            }
            n17 = 1;
            while (n17 < this.nstars) {
                this.rpssq[n17][2] = 0.0;
                n16 = 1;
                while (n16 < this.ncoords) {
                    double[] dArray = this.rpssq[n17];
                    dArray[2] = dArray[2] + this.xvec_ps[n17][n16][2] * this.xvec_ps[n17][n16][2];
                    ++n16;
                }
                this.rps[n17][2] = Math.sqrt(this.rpssq[n17][2]);
                this.rpscube[n17][2] = this.rps[n17][2] * this.rpssq[n17][2];
                ++n17;
            }
            if (this.istep) {
                int n34;
                n16 = 1;
                while (n16 < this.ncoords) {
                    this.k_1[n16][2] = 0.0;
                    n15 = 1;
                    while (n15 < this.nstars) {
                        double[] dArray = this.k_1[n16];
                        dArray[2] = dArray[2] + -0.5 * this.dtime * this.xvec_ps[n15][n16][2] / this.rpscube[n15][2];
                        ++n15;
                    }
                    ++n16;
                }
                n15 = 1;
                while (n15 < this.ncoords) {
                    this.l_1[n15][2] = this.vplanet[1][n15][2] * this.dtime;
                    ++n15;
                }
                n14 = 1;
                while (n14 < this.ncoords) {
                    double[] dArray = this.xplanet[1][n14];
                    dArray[2] = dArray[2] + 0.5 * this.l_1[n14][2];
                    double[] dArray7 = this.vplanet[1][n14];
                    dArray7[2] = dArray7[2] + 0.5 * this.k_1[n14][2];
                    ++n14;
                }
                n13 = 1;
                while (n13 < this.nstars) {
                    n12 = 1;
                    while (n12 < this.ncoords) {
                        this.xvec_ps[n13][n12][2] = this.xplanet[1][n12][2] - this.xstar[n13][n12];
                        ++n12;
                    }
                    ++n13;
                }
                n12 = 1;
                while (n12 < this.nstars) {
                    this.rpssq[n12][2] = 0.0;
                    n11 = 1;
                    while (n11 < this.ncoords) {
                        double[] dArray = this.rpssq[n12];
                        dArray[2] = dArray[2] + this.xvec_ps[n12][n11][2] * this.xvec_ps[n12][n11][2];
                        ++n11;
                    }
                    this.rps[n12][2] = Math.sqrt(this.rpssq[n12][2]);
                    this.rpscube[n12][2] = this.rps[n12][2] * this.rpssq[n12][2];
                    ++n12;
                }
                n11 = 1;
                while (n11 < this.ncoords) {
                    this.k_2[n11][2] = 0.0;
                    n10 = 1;
                    while (n10 < this.nstars) {
                        double[] dArray = this.k_2[n11];
                        dArray[2] = dArray[2] + -0.5 * this.dtime * this.xvec_ps[n10][n11][2] / this.rpscube[n10][2];
                        ++n10;
                    }
                    ++n11;
                }
                n10 = 1;
                while (n10 < this.ncoords) {
                    this.l_2[n10][2] = this.vplanet[1][n10][2] * this.dtime;
                    ++n10;
                }
                n9 = 1;
                while (n9 < this.ncoords) {
                    double[] dArray = this.xplanet[1][n9];
                    dArray[2] = dArray[2] + 0.5 * (this.l_2[n9][2] - this.l_1[n9][2]);
                    double[] dArray8 = this.vplanet[1][n9];
                    dArray8[2] = dArray8[2] + 0.5 * (this.k_2[n9][2] - this.k_1[n9][2]);
                    ++n9;
                }
                n8 = 1;
                while (n8 < this.nstars) {
                    n7 = 1;
                    while (n7 < this.ncoords) {
                        this.xvec_ps[n8][n7][2] = this.xplanet[1][n7][2] - this.xstar[n8][n7];
                        ++n7;
                    }
                    ++n8;
                }
                n7 = 1;
                while (n7 < this.nstars) {
                    this.rpssq[n7][2] = 0.0;
                    n6 = 1;
                    while (n6 < this.ncoords) {
                        double[] dArray = this.rpssq[n7];
                        dArray[2] = dArray[2] + this.xvec_ps[n7][n6][2] * this.xvec_ps[n7][n6][2];
                        ++n6;
                    }
                    this.rps[n7][2] = Math.sqrt(this.rpssq[n7][2]);
                    this.rpscube[n7][2] = this.rps[n7][2] * this.rpssq[n7][2];
                    ++n7;
                }
                n6 = 1;
                while (n6 < this.ncoords) {
                    this.k_3[n6][2] = 0.0;
                    n5 = 1;
                    while (n5 < this.nstars) {
                        double[] dArray = this.k_3[n6];
                        dArray[2] = dArray[2] + -0.5 * this.dtime * this.xvec_ps[n5][n6][2] / this.rpscube[n5][2];
                        ++n5;
                    }
                    ++n6;
                }
                n5 = 1;
                while (n5 < this.ncoords) {
                    this.l_3[n5][2] = this.vplanet[1][n5][2] * this.dtime;
                    ++n5;
                }
                n4 = 1;
                while (n4 < this.ncoords) {
                    double[] dArray = this.xplanet[1][n4];
                    dArray[2] = dArray[2] + (this.l_3[n4][2] - 0.5 * this.l_2[n4][2]);
                    double[] dArray9 = this.vplanet[1][n4];
                    dArray9[2] = dArray9[2] + (this.k_3[n4][2] - 0.5 * this.k_2[n4][2]);
                    ++n4;
                }
                n3 = 1;
                while (n3 < this.nstars) {
                    n2 = 1;
                    while (n2 < this.ncoords) {
                        this.xvec_ps[n3][n2][2] = this.xplanet[1][n2][2] - this.xstar[n3][n2];
                        ++n2;
                    }
                    ++n3;
                }
                n2 = 1;
                while (n2 < this.nstars) {
                    this.rpssq[n2][2] = 0.0;
                    n = 1;
                    while (n < this.ncoords) {
                        double[] dArray = this.rpssq[n2];
                        dArray[2] = dArray[2] + this.xvec_ps[n2][n][2] * this.xvec_ps[n2][n][2];
                        ++n;
                    }
                    this.rps[n2][2] = Math.sqrt(this.rpssq[n2][2]);
                    this.rpscube[n2][2] = this.rps[n2][2] * this.rpssq[n2][2];
                    ++n2;
                }
                n = 1;
                while (n < this.ncoords) {
                    this.k_4[n][2] = 0.0;
                    n34 = 1;
                    while (n34 < this.nstars) {
                        double[] dArray = this.k_4[n];
                        dArray[2] = dArray[2] + -0.5 * this.dtime * this.xvec_ps[n34][n][2] / this.rpscube[n34][2];
                        ++n34;
                    }
                    ++n;
                }
                n34 = 1;
                while (n34 < this.ncoords) {
                    this.l_4[n34][2] = this.vplanet[1][n34][2] * this.dtime;
                    ++n34;
                }
                int n35 = 1;
                while (n35 < this.ncoords) {
                    double[] dArray = this.xplanet[1][n35];
                    dArray[2] = dArray[2] + -this.l_3[n35][2];
                    double[] dArray10 = this.vplanet[1][n35];
                    dArray10[2] = dArray10[2] + -this.k_3[n35][2];
                    ++n35;
                }
                int n36 = 1;
                while (n36 < this.ncoords) {
                    double[] dArray = this.vplanet[1][n36];
                    dArray[2] = dArray[2] + (this.k_1[n36][2] + 2.0 * this.k_2[n36][2] + 2.0 * this.k_3[n36][2] + this.k_4[n36][2]) / 6.0;
                    double[] dArray11 = this.xplanet[1][n36];
                    dArray11[2] = dArray11[2] + (this.l_1[n36][2] + 2.0 * this.l_2[n36][2] + 2.0 * this.l_3[n36][2] + this.l_4[n36][2]) / 6.0;
                    ++n36;
                }
            }
            this.time += this.dtime;
            ++n19;
        }
        this.dtime = 2.0 * this.dtime;
        this.time -= this.dtime;
        if (this.istep) {
            this.time += this.dtime;
        }
        n18 = 1;
        while (n18 < this.ncoords) {
            this.vplanet[1][n18][3] = this.vplanet[1][n18][2] + 0.06666666666666667 * (this.vplanet[1][n18][2] - this.vplanet[1][n18][1]);
            this.xplanet[1][n18][3] = this.xplanet[1][n18][2] + 0.06666666666666667 * (this.xplanet[1][n18][2] - this.xplanet[1][n18][1]);
            ++n18;
        }
        this.xerr = Math.abs(this.xplanet[1][1][1] - this.xplanet[1][1][2]);
        this.yerr = Math.abs(this.xplanet[1][2][1] - this.xplanet[1][2][2]);
        this.xerrnumrecip = Math.abs(this.xplanet[1][1][3] - this.xplanet[1][1][2]);
        this.yerrnumrecip = Math.abs(this.xplanet[1][2][3] - this.xplanet[1][2][2]);
        if (this.igrid) {
            graphics.setColor(this.std_blue);
            graphics.drawArc(this.mrquart, this.mrquart, this.mrhalf, this.mrhalf, 0, 360);
            graphics.drawArc(0, 0, this.mrone, this.mrone, 0, 360);
            graphics.setColor(this.std_blue);
            graphics.drawLine(0, this.mrhalf, this.mrone, this.mrhalf);
            graphics.drawLine(this.mrhalf, 0, this.mrhalf, this.mrone);
            graphics.drawLine(this.ix1, this.ticy1, this.ix1, this.ticy2);
            graphics.drawLine(this.ix2, this.ticy1, this.ix2, this.ticy2);
            graphics.drawLine(this.ix3, this.ticy1, this.ix3, this.ticy2);
            graphics.drawLine(this.ix4, this.ticy1, this.ix4, this.ticy2);
            graphics.drawLine(this.ix5, this.ticy1, this.ix5, this.ticy2);
            graphics.drawLine(this.ticx1, this.iy1, this.ticx2, this.iy1);
            graphics.drawLine(this.ticx1, this.iy2, this.ticx2, this.iy2);
            graphics.drawLine(this.ticx1, this.iy3, this.ticx2, this.iy3);
            graphics.drawLine(this.ticx1, this.iy4, this.ticx2, this.iy4);
            graphics.drawLine(this.ticx1, this.iy5, this.ticx2, this.iy5);
            graphics.setColor(this.std_blue);
            graphics.drawString(String.valueOf(this.decimalPlace(1, 0.5 * this.screenscale / this.radscrn)) + " [AU]", 3 * this.mrquart + 5, this.mrhalf - 5);
            graphics.drawString(String.valueOf(this.decimalPlace(1, this.screenscale / this.radscrn)) + " [AU]", this.mrone + 5, this.mrhalf - 5);
        }
    }

    public void run() {
        while (this.thread != null) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
            this.repaint();
        }
        this.thread = null;
    }

    public void stop() {
        this.thread = null;
    }

    public void update(Graphics graphics) {
        Graphics graphics2 = this.offScreenImage.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.size().width, this.size().height);
        graphics2.setColor(graphics.getColor());
        this.paint(graphics2);
        graphics.drawImage(this.offScreenImage, 0, 0, this);
    }
}

